/*
 * Decompiled with CFR 0.152.
 */
package com.teamremastered.endrem.world.structures;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.teamremastered.endrem.config.ERConfig;
import com.teamremastered.endrem.utils.ERUtils;
import com.teamremastered.endrem.world.structures.config.ERStructures;
import com.teamremastered.endrem.world.structures.utils.CustomMonsterSpawn;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IStructureReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.event.world.StructureSpawnListGatherEvent;

public class EndGate
extends Structure<NoFeatureConfig> {
    private static final ResourceLocation START_POOL = new ResourceLocation("endrem", "end_gate/start_pool");
    private static final List<CustomMonsterSpawn> MONSTER_SPAWN_LIST = ImmutableList.of((Object)new CustomMonsterSpawn(EntityType.field_200741_ag, 30, 30, 35), (Object)new CustomMonsterSpawn(EntityType.field_200725_aD, 20, 25, 30), (Object)new CustomMonsterSpawn(EntityType.field_200794_h, 20, 25, 30), (Object)new CustomMonsterSpawn(EntityType.field_200759_ay, 10, 10, 15));

    public EndGate(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    @Nonnull
    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.STRONGHOLDS;
    }

    public static List<Biome.Category> getValidBiomeCategories() {
        ArrayList<Biome.Category> biomeCategories = new ArrayList<Biome.Category>();
        for (String biomeName : ERConfig.END_GATE_WHITELISTED_BIOME_CATEGORIES.getList()) {
            biomeCategories.add(Biome.Category.func_235103_a_((String)biomeName));
        }
        return biomeCategories;
    }

    public static void setupStructureSpawns(StructureSpawnListGatherEvent event) {
        if (event.getStructure() == ERStructures.END_GATE.get()) {
            for (CustomMonsterSpawn monsterSpawn : MONSTER_SPAWN_LIST) {
                event.addEntitySpawn(EntityClassification.MONSTER, monsterSpawn.getIndividualMobSpawnInfo());
            }
        }
    }

    @ParametersAreNonnullByDefault
    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig noFeatureConfig) {
        return ERUtils.getChunkDistanceFromSpawn(chunkPos) >= ERConfig.END_GATE_SPAWN_DISTANCE.getRaw();
    }

    @ParametersAreNonnullByDefault
    public BlockPos func_236388_a_(IWorldReader world, StructureManager manager, BlockPos blockPos, int radius, boolean skipExistingChunks, long seed, StructureSeparationSettings separationSettings) {
        int i = separationSettings.func_236668_a_();
        int j = blockPos.func_177958_n() >> 4;
        int k = blockPos.func_177952_p() >> 4;
        SharedSeedRandom worldgenrandom = new SharedSeedRandom();
        block0: for (int l = 0; l <= radius; ++l) {
            for (int i1 = -l; i1 <= l; ++i1) {
                boolean flag = i1 == -l || i1 == l;
                for (int j1 = -l; j1 <= l; ++j1) {
                    boolean flag1;
                    boolean bl = flag1 = j1 == -l || j1 == l;
                    if (!flag && !flag1) continue;
                    int k1 = j + i * i1;
                    int l1 = k + i * j1;
                    ChunkPos chunkpos = this.func_236392_a_(separationSettings, seed, worldgenrandom, k1, l1);
                    IChunk chunkAccess = world.func_217348_a(chunkpos.field_77276_a, chunkpos.field_77275_b, ChunkStatus.field_222606_b);
                    StructureStart structurestart = manager.func_235013_a_(SectionPos.func_218156_a((ChunkPos)chunkAccess.func_76632_l(), (int)0), (Structure)this, (IStructureReader)chunkAccess);
                    if (structurestart != null && structurestart.func_75069_d()) {
                        if (skipExistingChunks && structurestart.func_212687_g()) {
                            structurestart.func_212685_h();
                            return new BlockPos(((StructurePiece)structurestart.func_186161_c().get((int)((Start)structurestart).getLocatedRoom())).func_74874_b().field_78897_a, ((StructurePiece)structurestart.func_186161_c().get((int)((Start)structurestart).getLocatedRoom())).func_74874_b().field_78895_b, ((StructurePiece)structurestart.func_186161_c().get((int)((Start)structurestart).getLocatedRoom())).func_74874_b().field_78896_c);
                        }
                        if (!skipExistingChunks) {
                            return new BlockPos(((StructurePiece)structurestart.func_186161_c().get((int)((Start)structurestart).getLocatedRoom())).func_74874_b().field_78897_a, ((StructurePiece)structurestart.func_186161_c().get((int)((Start)structurestart).getLocatedRoom())).func_74874_b().field_78895_b, ((StructurePiece)structurestart.func_186161_c().get((int)((Start)structurestart).getLocatedRoom())).func_74874_b().field_78896_c);
                        }
                    }
                    if (l == 0) break;
                }
                if (l == 0) continue block0;
            }
        }
        return null;
    }

    @Nonnull
    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        @ParametersAreNonnullByDefault
        public void generatePieces(DynamicRegistries registryAccess, ChunkGenerator chunkGenerator, TemplateManager manager, int chunkX, int chunkZ, Biome biomeIn, NoFeatureConfig config) {
            BlockPos genPosition = new BlockPos(chunkX << 4, ERConfig.END_GATE_HEIGHT.getRaw().intValue(), chunkZ << 4);
            JigsawManager.func_242837_a((DynamicRegistries)registryAccess, (VillageConfig)new VillageConfig(() -> (JigsawPattern)registryAccess.func_243612_b(Registry.field_243555_ax).func_82594_a(START_POOL), ERConfig.END_GATE_SIZE.getRaw().intValue()), AbstractVillagePiece::new, (ChunkGenerator)chunkGenerator, (TemplateManager)manager, (BlockPos)genPosition, (List)this.field_75075_a, (Random)this.field_214631_d, (boolean)false, (boolean)false);
            this.func_202500_a();
        }

        public int getLocatedRoom() {
            return Math.min(16, this.field_75075_a.size()) - 1;
        }
    }
}

