/*
 * Decompiled with CFR 0.152.
 */
package com.teamremastered.endrem.world.structures;

import com.google.common.collect.ImmutableMap;
import com.teamremastered.endrem.world.structures.config.ERStructures;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class EndCastlePieces {
    private static final int height = 0;
    private static final ResourceLocation BOTTOM_LEFT = new ResourceLocation("endrem", "end_castle/castle_bl");
    private static final ResourceLocation MID_LEFT = new ResourceLocation("endrem", "end_castle/castle_ml");
    private static final ResourceLocation TOP_LEFT = new ResourceLocation("endrem", "end_castle/castle_tl");
    private static final ResourceLocation BOTTOM_MID = new ResourceLocation("endrem", "end_castle/castle_bm");
    private static final ResourceLocation BOTTOM_RIGHT = new ResourceLocation("endrem", "end_castle/castle_br");
    public static final ResourceLocation MID_RIGHT = new ResourceLocation("endrem", "end_castle/castle_mr");
    public static final ResourceLocation TOP_RIGHT = new ResourceLocation("endrem", "end_castle/castle_tr");
    public static final ResourceLocation TOP_MID = new ResourceLocation("endrem", "end_castle/castle_tm");
    public static final ResourceLocation MID_MID = new ResourceLocation("endrem", "end_castle/castle_mm");
    private static final Map<ResourceLocation, BlockPos> OFFSET = new ImmutableMap.Builder().put((Object)BOTTOM_LEFT, (Object)new BlockPos(20, 0, 24)).put((Object)TOP_LEFT, (Object)new BlockPos(-48, 0, 24)).put((Object)MID_LEFT, (Object)new BlockPos(-25, 0, 24)).put((Object)BOTTOM_RIGHT, (Object)new BlockPos(20, 0, -40)).put((Object)TOP_RIGHT, (Object)new BlockPos(-48, 0, -40)).put((Object)MID_RIGHT, (Object)new BlockPos(-24, 0, -47)).put((Object)BOTTOM_MID, (Object)new BlockPos(41, 0, 0)).put((Object)TOP_MID, (Object)new BlockPos(-48, 0, 0)).put((Object)MID_MID, (Object)new BlockPos(0, 0, 0)).build();

    public static void start(TemplateManager manager, BlockPos pos, Rotation rotation, List<StructurePiece> pieceList) {
        for (Map.Entry<ResourceLocation, BlockPos> entry : OFFSET.entrySet()) {
            pieceList.add((StructurePiece)new Piece(manager, entry.getKey(), entry.getValue().func_190942_a(rotation).func_177982_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), rotation));
        }
    }

    public static class Piece
    extends TemplateStructurePiece {
        private final ResourceLocation resourceLocation;
        private final Rotation rotation;

        public Piece(TemplateManager manager, ResourceLocation resourceLocationIn, BlockPos pos, Rotation rotationIn) {
            super(ERStructures.EC, 0);
            this.resourceLocation = resourceLocationIn;
            this.field_186178_c = pos;
            this.rotation = rotationIn;
            this.setupPiece(manager);
        }

        public Piece(TemplateManager manager, CompoundNBT tagCompound) {
            super(ERStructures.EC, tagCompound);
            this.resourceLocation = new ResourceLocation(tagCompound.func_74779_i("Template"));
            this.rotation = Rotation.valueOf((String)tagCompound.func_74779_i("Rot"));
            this.setupPiece(manager);
        }

        private void setupPiece(TemplateManager manager) {
            Template template = manager.func_200220_a(this.resourceLocation);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        @ParametersAreNonnullByDefault
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.resourceLocation.toString());
            tagCompound.func_74778_a("Rot", this.rotation.name());
        }

        @ParametersAreNonnullByDefault
        protected void func_186175_a(String chest, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            ResourceLocation lootTable = new ResourceLocation("endrem", String.format("chests/%s", chest));
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
            LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177977_b(), (ResourceLocation)lootTable);
        }
    }
}

