/*
 * Decompiled with CFR 0.152.
 */
package com.teamremastered.endrem.world.structures;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.teamremastered.endrem.config.ERConfig;
import com.teamremastered.endrem.utils.ERUtils;
import com.teamremastered.endrem.world.structures.EndCastlePieces;
import com.teamremastered.endrem.world.structures.config.ERStructures;
import com.teamremastered.endrem.world.structures.utils.CustomMonsterSpawn;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraftforge.event.world.StructureSpawnListGatherEvent;

public class EndCastle
extends Structure<NoFeatureConfig> {
    private static final List<CustomMonsterSpawn> MONSTER_SPAWN_LIST = ImmutableList.of((Object)new CustomMonsterSpawn(EntityType.field_220350_aJ, 15, 50, 55), (Object)new CustomMonsterSpawn(EntityType.field_200758_ax, 9, 45, 50), (Object)new CustomMonsterSpawn(EntityType.field_200806_t, 9, 15, 25), (Object)new CustomMonsterSpawn(EntityType.field_200764_D, 3, 10, 15));

    public EndCastle(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    @Nonnull
    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.UNDERGROUND_DECORATION;
    }

    public static void setupStructureSpawns(StructureSpawnListGatherEvent event) {
        if (event.getStructure() == ERStructures.END_CASTLE.get()) {
            for (CustomMonsterSpawn monsterSpawn : MONSTER_SPAWN_LIST) {
                event.addEntitySpawn(EntityClassification.MONSTER, monsterSpawn.getIndividualMobSpawnInfo());
            }
        }
    }

    public static List<Biome.Category> getValidBiomeCategories() {
        ArrayList<Biome.Category> biomeCategories = new ArrayList<Biome.Category>();
        for (String biomeName : ERConfig.END_CASTLE_WHITELISTED_BIOME_CATEGORIES.getList()) {
            biomeCategories.add(Biome.Category.func_235103_a_((String)biomeName));
        }
        return biomeCategories;
    }

    @ParametersAreNonnullByDefault
    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig noFeatureConfig) {
        return ERUtils.getChunkDistanceFromSpawn(chunkPos) >= ERConfig.END_CASTLE_SPAWN_DISTANCE.getRaw();
    }

    @Nonnull
    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        @ParametersAreNonnullByDefault
        public void generatePieces(DynamicRegistries registryAccess, ChunkGenerator chunkGenerator, TemplateManager manager, int chunkX, int chunkZ, Biome biomeIn, NoFeatureConfig config) {
            Rotation rotation = Rotation.values()[this.field_214631_d.nextInt(Rotation.values().length)];
            int x = chunkX << 4;
            int z = chunkZ << 4;
            if (rotation == Rotation.CLOCKWISE_90) {
                x += 17;
                z += 43;
            } else if (rotation == Rotation.CLOCKWISE_180) {
                x -= 43;
                z += 17;
            } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                x -= 17;
                z -= 43;
            } else {
                x += 43;
                z -= 17;
            }
            int surfaceY = chunkGenerator.func_222529_a(x, z, Heightmap.Type.WORLD_SURFACE_WG);
            BlockPos genPosition = new BlockPos(x, surfaceY, z);
            EndCastlePieces.start(manager, genPosition, rotation, this.field_75075_a);
            this.func_202500_a();
        }

        @ParametersAreNonnullByDefault
        public void func_230366_a_(ISeedReader seedReader, StructureManager featureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox boundingBox, ChunkPos chunkPos) {
            super.func_230366_a_(seedReader, featureManager, chunkGenerator, random, boundingBox, chunkPos);
            int i = this.field_75074_b.field_78895_b;
            for (int j = boundingBox.field_78897_a; j <= boundingBox.field_78893_d; ++j) {
                for (int k = boundingBox.field_78896_c; k <= boundingBox.field_78892_f; ++k) {
                    BlockPos blockpos1;
                    BlockPos blockpos = new BlockPos(j, i, k);
                    if (seedReader.func_175623_d(blockpos) || !this.field_75074_b.func_175898_b((Vector3i)blockpos)) continue;
                    boolean flag = false;
                    for (StructurePiece structurepiece : this.field_75075_a) {
                        if (!structurepiece.func_74874_b().func_175898_b((Vector3i)blockpos)) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) continue;
                    for (int l = i - 1; l > 1 && (seedReader.func_175623_d(blockpos1 = new BlockPos(j, l, k)) || seedReader.func_180495_p(blockpos1).func_185904_a().func_76224_d()); --l) {
                        double randomBlock = Math.random();
                        if (randomBlock <= 0.05) {
                            seedReader.func_180501_a(blockpos1, Blocks.field_150348_b.func_176223_P(), 2);
                            continue;
                        }
                        if (randomBlock <= 0.1) {
                            seedReader.func_180501_a(blockpos1, Blocks.field_150347_e.func_176223_P(), 2);
                            continue;
                        }
                        if (randomBlock <= 0.2) {
                            seedReader.func_180501_a(blockpos1, Blocks.field_196656_g.func_176223_P(), 2);
                            continue;
                        }
                        if (randomBlock <= 0.3) {
                            seedReader.func_180501_a(blockpos1, Blocks.field_196696_di.func_176223_P(), 2);
                            continue;
                        }
                        if (randomBlock <= 0.4) {
                            seedReader.func_180501_a(blockpos1, Blocks.field_196700_dk.func_176223_P(), 2);
                            continue;
                        }
                        if (randomBlock <= 0.5) {
                            seedReader.func_180501_a(blockpos1, Blocks.field_196656_g.func_176223_P(), 2);
                            continue;
                        }
                        seedReader.func_180501_a(blockpos1, Blocks.field_196657_h.func_176223_P(), 2);
                    }
                }
            }
        }
    }
}

