/*
 * Decompiled with CFR 0.152.
 */
package com.teamremastered.endrem.world.structures;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.teamremastered.endrem.world.structures.config.ERStructures;
import com.teamremastered.endrem.world.structures.utils.CustomMonsterSpawn;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraftforge.event.world.StructureSpawnListGatherEvent;

public class AncientWitchHut
extends Structure<NoFeatureConfig> {
    private static final ResourceLocation START_POOL = new ResourceLocation("endrem", "ancient_witch_hut/start_pool");
    private static final List<CustomMonsterSpawn> MONSTER_SPAWN_LIST = ImmutableList.of((Object)new CustomMonsterSpawn(EntityType.field_200741_ag, 5, 5, 10), (Object)new CustomMonsterSpawn(EntityType.field_200759_ay, 10, 10, 15));

    public AncientWitchHut(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    @Nonnull
    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    public static void setupStructureSpawns(StructureSpawnListGatherEvent event) {
        if (event.getStructure() == ERStructures.ANCIENT_WITCH_HUT.get()) {
            for (CustomMonsterSpawn monsterSpawn : MONSTER_SPAWN_LIST) {
                event.addEntitySpawn(EntityClassification.MONSTER, monsterSpawn.getIndividualMobSpawnInfo());
            }
        }
    }

    public static List<Biome.Category> getValidBiomeCategories() {
        return ImmutableList.of((Object)Biome.Category.SWAMP);
    }

    @Nonnull
    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        @ParametersAreNonnullByDefault
        public void generatePieces(DynamicRegistries registryAccess, ChunkGenerator chunkGenerator, TemplateManager manager, int chunkX, int chunkZ, Biome biomeIn, NoFeatureConfig config) {
            BlockPos genPosition = new BlockPos(chunkX << 4, -3, chunkZ << 4);
            JigsawManager.func_242837_a((DynamicRegistries)registryAccess, (VillageConfig)new VillageConfig(() -> (JigsawPattern)registryAccess.func_243612_b(Registry.field_243555_ax).func_82594_a(START_POOL), 2), AbstractVillagePiece::new, (ChunkGenerator)chunkGenerator, (TemplateManager)manager, (BlockPos)genPosition, (List)this.field_75075_a, (Random)this.field_214631_d, (boolean)false, (boolean)true);
            this.func_202500_a();
        }
    }
}

