/*
 * Decompiled with CFR 0.152.
 */
package com.teamremastered.endrem.items;

import com.teamremastered.endrem.EndRemastered;
import com.teamremastered.endrem.config.ERConfig;
import com.teamremastered.endrem.registers.ERItems;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNullableByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EndCrystalArmor
extends ArmorItem {
    public EndCrystalArmor(EquipmentSlotType slot) {
        super((IArmorMaterial)new EndCrystalArmorMaterial(), slot, new Item.Properties().func_200916_a(EndRemastered.TAB).func_208103_a(Rarity.UNCOMMON));
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        int layer;
        int n = layer = slot == EquipmentSlotType.LEGS ? 2 : 1;
        if ("overlay".equals(type)) {
            return "endrem:textures/models/armor/all_layer_" + layer + "_overlay.png";
        }
        return "endrem:textures/models/armor/end_crystal_layer_" + layer + ".png";
    }

    @ParametersAreNullableByDefault
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World level, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        assert (tooltip != null);
        tooltip.add((ITextComponent)new TranslationTextComponent("item.endrem.armor.description.main"));
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return Boolean.parseBoolean(ERConfig.END_CRYSTAL_ARMOR_STATS.getList().get(4));
    }

    @MethodsReturnNonnullByDefault
    private static class EndCrystalArmorMaterial
    implements IArmorMaterial {
        private EndCrystalArmorMaterial() {
        }

        public int func_200896_a(EquipmentSlotType slotIn) {
            double factor = Double.parseDouble(ERConfig.END_CRYSTAL_ARMOR_STATS.getList().get(0));
            return (int)((double)(new int[]{13, 15, 16, 11})[slotIn.func_188454_b()] * factor);
        }

        public int func_200902_b(EquipmentSlotType slotIn) {
            double factor = Double.parseDouble(ERConfig.END_CRYSTAL_ARMOR_STATS.getList().get(1));
            return (int)((double)(new int[]{3, 6, 8, 3})[slotIn.func_188454_b()] * factor);
        }

        public int func_200900_a() {
            return 15;
        }

        public Ingredient func_200898_c() {
            return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ERItems.END_CRYSTAL_INGOT.get()});
        }

        public float func_200901_e() {
            return Float.parseFloat(ERConfig.END_CRYSTAL_ARMOR_STATS.getList().get(2));
        }

        public float func_230304_f_() {
            return Float.parseFloat(ERConfig.END_CRYSTAL_ARMOR_STATS.getList().get(3));
        }

        public SoundEvent func_200899_b() {
            return SoundEvents.field_187719_p;
        }

        @OnlyIn(value=Dist.CLIENT)
        public String func_200897_d() {
            return "end_crystal_fragment";
        }
    }
}

