/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.event;

import com.stal111.valhelsia_structures.config.StructureConfigEntry;
import com.stal111.valhelsia_structures.config.StructureGenConfig;
import com.stal111.valhelsia_structures.init.ModStructures;
import com.stal111.valhelsia_structures.world.structures.AbstractValhelsiaStructure;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.valhelsia.valhelsia_core.world.IValhelsiaStructure;

@Mod.EventBusSubscriber
public class WorldLoadListener {
    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            if (serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
            HashMap<AbstractValhelsiaStructure, Object> tempMap = new HashMap<AbstractValhelsiaStructure, Object>(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            ResourceLocation currDimension = serverWorld.func_234923_W_().func_240901_a_();
            for (String dimension : (List)StructureGenConfig.BLACKLISTED_DIMENSIONS.get()) {
                if (!dimension.equals(currDimension.toString())) {
                    if (!WorldLoadListener.checkWildcard(dimension, currDimension.toString())) continue;
                }
                ModStructures.MOD_STRUCTURES.stream().map(IValhelsiaStructure::getStructure).collect(Collectors.toList()).forEach(tempMap.keySet()::remove);
                serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
                return;
            }
            for (IValhelsiaStructure iStructure : ModStructures.MOD_STRUCTURES) {
                AbstractValhelsiaStructure structure = (AbstractValhelsiaStructure)iStructure.getStructure();
                StructureConfigEntry configEntry = structure.getStructureConfigEntry();
                if (WorldLoadListener.checkDimension((List)configEntry.configuredBlacklistedDimensions.get(), currDimension)) {
                    tempMap.putIfAbsent(structure, DimensionStructuresSettings.field_236191_b_.get((Object)structure));
                    continue;
                }
                tempMap.keySet().remove((Object)structure);
            }
            serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
        }
    }

    private static boolean checkWildcard(String blacklistedDimension, String dimension) {
        if (blacklistedDimension.startsWith("*") && blacklistedDimension.endsWith("*")) {
            return dimension.contains(blacklistedDimension.substring(1, blacklistedDimension.length() - 1));
        }
        if (blacklistedDimension.startsWith("*")) {
            return dimension.endsWith(blacklistedDimension.substring(1));
        }
        if (blacklistedDimension.endsWith("*")) {
            return dimension.startsWith(blacklistedDimension.substring(0, blacklistedDimension.length() - 1));
        }
        return false;
    }

    private static boolean checkDimension(List<? extends String> blacklistedDimensions, ResourceLocation name) {
        boolean flag = true;
        if (!blacklistedDimensions.isEmpty()) {
            boolean bl = flag = !blacklistedDimensions.contains(name.toString());
            if (flag) {
                for (String string : blacklistedDimensions) {
                    if (!WorldLoadListener.checkWildcard(string, name.toString())) continue;
                    flag = false;
                    break;
                }
            }
        }
        return flag;
    }
}

