/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.endergetic.common.world.features.corrock.tower;

import com.google.common.collect.Lists;
import com.minecraftabnormals.abnormals_core.core.util.GenerationPiece;
import com.minecraftabnormals.endergetic.api.util.GenerationUtils;
import com.minecraftabnormals.endergetic.common.world.configs.CorrockTowerConfig;
import com.minecraftabnormals.endergetic.common.world.features.corrock.AbstractCorrockFeature;
import com.minecraftabnormals.endergetic.core.registry.EEBlocks;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;

public final class MediumCorrockTowerFeature
extends AbstractCorrockFeature<CorrockTowerConfig> {
    public MediumCorrockTowerFeature(Codec<CorrockTowerConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, CorrockTowerConfig config) {
        Block belowBlock = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (world.func_175623_d(pos) && belowBlock == EEBlocks.CORROCK_END_BLOCK.get()) {
            BlockState corrockBlockState = (BlockState)CORROCK_BLOCK_STATE.func_179281_c();
            GenerationPiece base = new GenerationPiece((w, p) -> w.func_175623_d(p.pos));
            int height = rand.nextInt(config.getMaxHeight() - config.getMinHeight() + 1) + config.getMinHeight();
            MediumCorrockTowerFeature.fillUp(base, corrockBlockState, pos, height);
            if (!base.canPlace((IWorld)world)) {
                return false;
            }
            BlockPos downPos = pos.func_177979_c(2);
            BlockPos.Mutable mutable = new BlockPos.Mutable();
            if (GenerationUtils.isAreaCompletelySolid((IWorld)world, downPos.func_177958_n() - 1, downPos.func_177956_o(), downPos.func_177952_p() - 1, downPos.func_177958_n() + 1, downPos.func_177956_o(), downPos.func_177952_p() + 1)) {
                for (int x = downPos.func_177958_n() - 1; x <= downPos.func_177958_n() + 1; ++x) {
                    for (int y = downPos.func_177956_o(); y <= downPos.func_177956_o() + 1; ++y) {
                        for (int z = downPos.func_177952_p() - 1; z <= downPos.func_177952_p() + 1; ++z) {
                            mutable.func_181079_c(x, y, z);
                            if (!world.func_175623_d((BlockPos)mutable)) continue;
                            base.addBlockPiece(corrockBlockState, mutable.func_185334_h());
                        }
                    }
                }
            } else {
                return false;
            }
            int heightMinusOne = height - 1;
            for (Direction horizontal : Direction.Plane.HORIZONTAL) {
                BlockPos offset = pos.func_177972_a(horizontal);
                BlockPos doubleOffset = pos.func_177967_a(horizontal, 2);
                MediumCorrockTowerFeature.fillUp(base, corrockBlockState, offset, height);
                if (rand.nextBoolean()) {
                    base.addBlockPiece(corrockBlockState, offset.func_177972_a(horizontal.func_176746_e()));
                }
                if (rand.nextBoolean()) {
                    base.addBlockPiece(corrockBlockState, offset.func_177972_a(horizontal.func_176735_f()));
                }
                if (rand.nextBoolean()) {
                    base.addBlockPiece(corrockBlockState, offset.func_177981_b(heightMinusOne).func_177972_a(horizontal.func_176746_e()));
                }
                if (rand.nextBoolean()) {
                    base.addBlockPiece(corrockBlockState, offset.func_177981_b(heightMinusOne).func_177972_a(horizontal.func_176735_f()));
                }
                if (rand.nextBoolean()) {
                    base.addBlockPiece(corrockBlockState, doubleOffset);
                }
                if (!rand.nextBoolean()) continue;
                base.addBlockPiece(corrockBlockState, doubleOffset.func_177981_b(heightMinusOne));
            }
            int x = 0;
            int z = 0;
            if (rand.nextBoolean()) {
                x = rand.nextInt(2);
            } else {
                z = rand.nextInt(2);
            }
            Pair<GenerationPiece, List<AbstractCorrockFeature.ChorusPlantPart>> topPiece = MediumCorrockTowerFeature.getTop((IWorld)world, pos.func_177982_a(x, height + 1, z), rand, config.getCrownChance(), config.getChorusChance());
            if (base.canPlace((IWorld)world) && ((GenerationPiece)topPiece.getFirst()).canPlace((IWorld)world)) {
                base.place((IWorld)world);
                ((GenerationPiece)topPiece.getFirst()).place((IWorld)world);
                ((List)topPiece.getSecond()).forEach(growth -> growth.placeGrowth((IWorld)world, rand));
                BlockPos topMiddle = pos.func_177981_b(height + 1);
                BlockState corrockPlantState = (BlockState)CORROCK_STATE.func_179281_c();
                for (int i = 0; i < 16; ++i) {
                    if (!(rand.nextFloat() < 0.6f) || !world.func_175623_d((BlockPos)mutable.func_239621_a_((Vector3i)topMiddle, rand.nextInt(6) - rand.nextInt(6), rand.nextInt(2) - rand.nextInt(2), rand.nextInt(6) - rand.nextInt(6))) || world.func_180495_p(mutable.func_177977_b()).func_177230_c() != CORROCK_BLOCK_BLOCK) continue;
                    world.func_180501_a((BlockPos)mutable, corrockPlantState, 2);
                }
                return true;
            }
        }
        return false;
    }

    private static void fillUp(GenerationPiece piece, BlockState state, BlockPos pos, int height) {
        for (int i = 0; i < height; ++i) {
            piece.addBlockPiece(state, pos.func_177981_b(i));
        }
    }

    private static Pair<GenerationPiece, List<AbstractCorrockFeature.ChorusPlantPart>> getTop(IWorld world, BlockPos pos, Random rand, float crownChance, float chorusChance) {
        GenerationPiece top = new GenerationPiece((w, p) -> w.func_175623_d(p.pos));
        ArrayList growths = Lists.newArrayList();
        ArrayList corners = Lists.newArrayList();
        int variant = rand.nextInt(4);
        BlockPos startNPos = pos.func_177967_a(Direction.NORTH, 4).func_177982_a(-2, 0, 0);
        BlockState corrockBlockState = (BlockState)CORROCK_BLOCK_STATE.func_179281_c();
        for (int i = 0; i < 4; ++i) {
            BlockPos placePos = startNPos.func_177982_a(i, 0, 0);
            top.addBlockPiece(corrockBlockState, placePos);
            if (!(rand.nextFloat() < crownChance)) continue;
            if (rand.nextBoolean()) {
                top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownWall(Direction.NORTH), placePos.func_177972_a(Direction.NORTH));
                continue;
            }
            top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownStanding(rand.nextInt(16)), placePos.func_177984_a());
        }
        BlockPos startEPos = pos.func_177967_a(Direction.EAST, 3).func_177982_a(0, 0, 1);
        for (int i = 0; i < 4; ++i) {
            BlockPos placePos = startEPos.func_177982_a(0, 0, -i);
            top.addBlockPiece(corrockBlockState, placePos);
            if (!(rand.nextFloat() < crownChance)) continue;
            if (rand.nextBoolean()) {
                top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownWall(Direction.EAST), placePos.func_177972_a(Direction.EAST));
                continue;
            }
            top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownStanding(rand.nextInt(16)), placePos.func_177984_a());
        }
        BlockPos startSPos = pos.func_177967_a(Direction.SOUTH, 3).func_177982_a(1, 0, 0);
        for (int i = 0; i < 4; ++i) {
            BlockPos placePos = startSPos.func_177982_a(-i, 0, 0);
            top.addBlockPiece(corrockBlockState, placePos);
            if (!(rand.nextFloat() < crownChance)) continue;
            if (rand.nextBoolean()) {
                top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownWall(Direction.SOUTH), placePos.func_177972_a(Direction.SOUTH));
                continue;
            }
            top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownStanding(rand.nextInt(16)), placePos.func_177984_a());
        }
        BlockPos startWPos = pos.func_177967_a(Direction.WEST, 4).func_177982_a(0, 0, 1);
        for (int i = 0; i < 4; ++i) {
            BlockPos placePos = startWPos.func_177982_a(0, 0, -i);
            top.addBlockPiece(corrockBlockState, placePos);
            if (!(rand.nextFloat() < crownChance)) continue;
            if (rand.nextBoolean()) {
                top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownWall(Direction.WEST), placePos.func_177972_a(Direction.WEST));
                continue;
            }
            top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownStanding(rand.nextInt(16)), placePos.func_177984_a());
        }
        BlockPos cornerNW = pos.func_177982_a(-3, 0, -3);
        if (variant != 0) {
            corners.add(cornerNW.func_177972_a(Direction.SOUTH));
            corners.add(cornerNW.func_177972_a(Direction.EAST));
        }
        if (rand.nextFloat() < crownChance) {
            if (rand.nextBoolean()) {
                top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownStanding(rand.nextInt(16)), cornerNW.func_177984_a());
            } else {
                if (rand.nextFloat() < crownChance) {
                    top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownWall(Direction.NORTH), cornerNW.func_177972_a(Direction.NORTH));
                }
                if (rand.nextFloat() < crownChance) {
                    top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownWall(Direction.WEST), cornerNW.func_177972_a(Direction.WEST));
                }
            }
        }
        corners.add(cornerNW);
        BlockPos cornerNE = pos.func_177982_a(2, 0, -3);
        if (variant != 1) {
            corners.add(cornerNE.func_177972_a(Direction.SOUTH));
            corners.add(cornerNE.func_177972_a(Direction.WEST));
        }
        if (rand.nextFloat() < crownChance) {
            if (rand.nextBoolean()) {
                top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownStanding(rand.nextInt(16)), cornerNE.func_177984_a());
            } else {
                if (rand.nextFloat() < crownChance) {
                    top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownWall(Direction.NORTH), cornerNE.func_177972_a(Direction.NORTH));
                }
                if (rand.nextFloat() < crownChance) {
                    top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownWall(Direction.EAST), cornerNE.func_177972_a(Direction.EAST));
                }
            }
        }
        corners.add(cornerNE);
        BlockPos cornerSE = pos.func_177982_a(2, 0, 2);
        if (variant != 2) {
            corners.add(cornerSE.func_177972_a(Direction.NORTH));
            corners.add(cornerSE.func_177972_a(Direction.WEST));
        }
        if (rand.nextFloat() < crownChance) {
            if (rand.nextBoolean()) {
                top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownStanding(rand.nextInt(16)), cornerSE.func_177984_a());
            } else {
                if (rand.nextFloat() < crownChance) {
                    top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownWall(Direction.SOUTH), cornerSE.func_177972_a(Direction.SOUTH));
                }
                if (rand.nextFloat() < crownChance) {
                    top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownWall(Direction.EAST), cornerSE.func_177972_a(Direction.EAST));
                }
            }
        }
        corners.add(cornerSE);
        BlockPos cornerSW = pos.func_177982_a(-3, 0, 2);
        if (variant != 3) {
            corners.add(cornerSW.func_177972_a(Direction.NORTH));
            corners.add(cornerSW.func_177972_a(Direction.EAST));
        }
        if (rand.nextFloat() < crownChance) {
            if (rand.nextBoolean()) {
                top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownStanding(rand.nextInt(16)), cornerSW.func_177984_a());
            } else {
                if (rand.nextFloat() < crownChance) {
                    top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownWall(Direction.SOUTH), cornerSW.func_177972_a(Direction.SOUTH));
                }
                if (rand.nextFloat() < crownChance) {
                    top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownWall(Direction.WEST), cornerSW.func_177972_a(Direction.WEST));
                }
            }
        }
        corners.add(cornerSW);
        for (int x = cornerNW.func_177958_n(); x <= cornerSE.func_177958_n(); ++x) {
            for (int z = cornerNW.func_177952_p(); z <= cornerSE.func_177952_p(); ++z) {
                BlockPos placingPos = new BlockPos(x, pos.func_177956_o(), z);
                if (corners.contains(placingPos)) continue;
                if (MediumCorrockTowerFeature.isNotCloseToAnotherGrowth(growths, placingPos.func_177977_b()) && rand.nextFloat() < chorusChance && world.func_175623_d(placingPos) && world.func_175623_d(placingPos.func_177984_a())) {
                    growths.add(new AbstractCorrockFeature.ChorusPlantPart(placingPos.func_177977_b()));
                    for (Direction direction : Direction.values()) {
                        if (direction == Direction.UP) continue;
                        top.addBlockPiece(corrockBlockState, placingPos.func_177977_b().func_177972_a(direction));
                    }
                    continue;
                }
                top.addBlockPiece(corrockBlockState, placingPos.func_177977_b());
            }
        }
        for (BlockPos positions : corners) {
            top.addBlockPiece(corrockBlockState, positions);
        }
        return Pair.of((Object)top, (Object)growths);
    }
}

