/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.endergetic.api.entity.pathfinding;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.MobEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.pathfinding.FlaggedPathPoint;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;

public class EndergeticFlyingNodeProcessor
extends NodeProcessor {
    public PathPoint func_186318_b() {
        return super.func_176159_a(MathHelper.func_76128_c((double)this.field_186326_b.func_174813_aQ().field_72340_a), MathHelper.func_76128_c((double)(this.field_186326_b.func_174813_aQ().field_72338_b + 0.5)), MathHelper.func_76128_c((double)this.field_186326_b.func_174813_aQ().field_72339_c));
    }

    public FlaggedPathPoint func_224768_a(double p_224768_1_, double p_224768_3_, double p_224768_5_) {
        return new FlaggedPathPoint(super.func_176159_a(MathHelper.func_76128_c((double)(p_224768_1_ - (double)(this.field_186326_b.func_213311_cf() / 2.0f))), MathHelper.func_76128_c((double)(p_224768_3_ + 0.5)), MathHelper.func_76128_c((double)(p_224768_5_ - (double)(this.field_186326_b.func_213311_cf() / 2.0f)))));
    }

    public int func_222859_a(PathPoint[] pathPoints, PathPoint pathNode) {
        int i = 0;
        for (Direction direction : Direction.values()) {
            PathPoint pathpoint = this.getPoint(pathNode.field_75839_a + direction.func_82601_c(), pathNode.field_75837_b + direction.func_96559_d(), pathNode.field_75838_c + direction.func_82599_e());
            if (pathpoint == null || pathpoint.field_75842_i) continue;
            pathPoints[i++] = pathpoint;
        }
        return i;
    }

    public PathNodeType func_186319_a(IBlockReader blockaccessIn, int x, int y, int z, MobEntity entitylivingIn, int xSize, int ySize, int zSize, boolean canBreakDoorsIn, boolean canEnterDoorsIn) {
        return this.func_186330_a(blockaccessIn, x, y, z);
    }

    public PathNodeType func_186330_a(IBlockReader blockaccessIn, int x, int y, int z) {
        BlockPos blockpos = new BlockPos(x, y, z);
        BlockState blockstate = blockaccessIn.func_180495_p(blockpos);
        return blockstate.func_196957_g(blockaccessIn, blockpos, PathType.AIR) ? PathNodeType.WALKABLE : PathNodeType.BLOCKED;
    }

    @Nullable
    private PathPoint getPoint(int x, int y, int z) {
        PathNodeType pathnodetype = this.isFree(x, y, z);
        return pathnodetype != PathNodeType.BREACH && pathnodetype != PathNodeType.WALKABLE ? null : this.func_176159_a(x, y, z);
    }

    protected PathPoint func_176159_a(int x, int y, int z) {
        PathPoint pathpoint = null;
        PathNodeType pathnodetype = this.func_186330_a((IBlockReader)this.field_186326_b.field_70170_p, x, y, z);
        float malus = this.field_186326_b.func_184643_a(pathnodetype);
        if (malus >= 0.0f) {
            pathpoint = super.func_176159_a(x, y, z);
            pathpoint.field_186287_m = pathnodetype;
            pathpoint.field_186286_l = Math.max(pathpoint.field_186286_l, malus);
            if (this.field_176169_a.func_204610_c(new BlockPos(x, y, z)).func_206888_e()) {
                pathpoint.field_186286_l += 8.0f;
            }
        }
        return pathpoint;
    }

    private PathNodeType isFree(int x, int y, int z) {
        BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable();
        for (int i = x; i < x + this.field_176168_c; ++i) {
            for (int j = y; j < y + this.field_176165_d; ++j) {
                for (int k = z; k < z + this.field_176166_e; ++k) {
                    FluidState ifluidstate = this.field_176169_a.func_204610_c((BlockPos)blockpos$mutableblockpos.func_181079_c(i, j, k));
                    BlockState blockstate = this.field_176169_a.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(i, j, k));
                    if (ifluidstate.func_206888_e() && blockstate.func_196957_g((IBlockReader)this.field_176169_a, blockpos$mutableblockpos.func_177977_b(), PathType.AIR) && blockstate.func_196958_f()) {
                        return PathNodeType.WALKABLE;
                    }
                    if (!ifluidstate.func_206884_a((ITag)FluidTags.field_206959_a)) continue;
                    return PathNodeType.BLOCKED;
                }
            }
        }
        BlockState blockstate1 = this.field_176169_a.func_180495_p((BlockPos)blockpos$mutableblockpos);
        if (blockstate1.func_196957_g((IBlockReader)this.field_176169_a, (BlockPos)blockpos$mutableblockpos, PathType.AIR)) {
            return PathNodeType.WALKABLE;
        }
        return PathNodeType.BLOCKED;
    }
}

