/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.world;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import someoneelse.betternetherreforged.biomes.NetherBiome;
import someoneelse.betternetherreforged.registry.NetherBiomesRegistry;
import someoneelse.betternetherreforged.world.BNWorldGenerator;
import someoneelse.betternetherreforged.world.BiomeMap;

public class NetherBiomeProvider
extends BiomeProvider {
    public static final Codec<NetherBiomeProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).forGetter(theEndBiomeSource -> theEndBiomeSource.biomeRegistry), (App)Codec.LONG.fieldOf("seed").stable().forGetter(theEndBiomeSource -> theEndBiomeSource.seed)).apply((Applicative)instance, instance.stable(NetherBiomeProvider::new)));
    private BiomeMap map;
    private final long seed;
    private final Registry<Biome> biomeRegistry;

    public NetherBiomeProvider(Registry<Biome> biomeRegistry, long seed) {
        super(NetherBiomeProvider.getBiomes(biomeRegistry));
        this.seed = seed;
        this.map = new BiomeMap(seed, BNWorldGenerator.biomeSizeXZ, BNWorldGenerator.biomeSizeY, BNWorldGenerator.volumetric);
        this.biomeRegistry = biomeRegistry;
        NetherBiomesRegistry.mapBiomes(biomeRegistry);
    }

    private static List<Biome> getBiomes(Registry<Biome> biomeRegistry) {
        ArrayList result = Lists.newArrayList();
        biomeRegistry.forEach(biome -> {
            if (biome.func_201856_r() == Biome.Category.NETHER) {
                result.add(biome);
            }
        });
        return result;
    }

    public Biome func_225526_b_(int biomeX, int biomeY, int biomeZ) {
        NetherBiome netherBiome = this.map.getBiome(biomeX << 2, biomeY << 2, biomeZ << 2);
        if (biomeX == 0 && biomeZ == 0) {
            this.map.clearCache();
        }
        return netherBiome.getActualBiome();
    }

    public BiomeProvider func_230320_a_(long seed) {
        return new NetherBiomeProvider(this.biomeRegistry, seed);
    }

    protected Codec<? extends BiomeProvider> func_230319_a_() {
        return CODEC;
    }

    public static void register() {
        Registry.func_218322_a((Registry)Registry.field_239689_aA_, (ResourceLocation)new ResourceLocation("betternether", "nether_biome_source"), CODEC);
    }
}

