/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.tileentities;

import java.util.Arrays;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.BrewingStandBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.BrewingStandContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.PotionBrewing;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import someoneelse.betternetherreforged.registry.BrewingRegistry;
import someoneelse.betternetherreforged.registry.TileEntitiesRegistry;

public class BNBrewingStandTileEntity
extends LockableTileEntity
implements ISidedInventory,
ITickableTileEntity {
    private static final int[] TOP_SLOTS = new int[]{3};
    private static final int[] BOTTOM_SLOTS = new int[]{0, 1, 2, 3};
    private static final int[] SIDE_SLOTS = new int[]{0, 1, 2, 4};
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    private int brewTime;
    private boolean[] slotsEmptyLastTick;
    private Item itemBrewing;
    private int fuel;
    protected final IIntArray propertyDelegate = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return BNBrewingStandTileEntity.this.brewTime;
                }
                case 1: {
                    return BNBrewingStandTileEntity.this.fuel;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    BNBrewingStandTileEntity.this.brewTime = value;
                    break;
                }
                case 1: {
                    BNBrewingStandTileEntity.this.fuel = value;
                }
            }
        }

        public int func_221478_a() {
            return 2;
        }
    };

    public BNBrewingStandTileEntity() {
        super(TileEntitiesRegistry.NETHER_BREWING_STAND);
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.brewing", new Object[0]);
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        ItemStack itemStack;
        Iterator var1 = this.inventory.iterator();
        do {
            if (var1.hasNext()) continue;
            return true;
        } while ((itemStack = (ItemStack)var1.next()).func_190926_b());
        return false;
    }

    public void func_73660_a() {
        boolean[] bls;
        ItemStack itemStack = (ItemStack)this.inventory.get(4);
        if (this.fuel <= 0 && itemStack.func_77973_b() == Items.field_151065_br) {
            this.fuel = 20;
            itemStack.func_190918_g(1);
            this.func_70296_d();
        }
        boolean bl = this.canCraft();
        boolean bl2 = this.brewTime > 0;
        ItemStack itemStack2 = (ItemStack)this.inventory.get(3);
        if (bl2) {
            boolean bl3;
            --this.brewTime;
            boolean bl4 = bl3 = this.brewTime == 0;
            if (bl3 && bl) {
                this.craft();
                this.func_70296_d();
            } else if (!bl) {
                this.brewTime = 0;
                this.func_70296_d();
            } else if (this.itemBrewing != itemStack2.func_77973_b()) {
                this.brewTime = 0;
                this.func_70296_d();
            }
        } else if (bl && this.fuel > 0) {
            --this.fuel;
            this.brewTime = 400;
            this.itemBrewing = itemStack2.func_77973_b();
            this.func_70296_d();
        }
        if (!this.field_145850_b.field_72995_K && !Arrays.equals(bls = this.getSlotsEmpty(), this.slotsEmptyLastTick)) {
            this.slotsEmptyLastTick = bls;
            BlockState blockState = this.field_145850_b.func_180495_p(this.func_174877_v());
            if (!(blockState.func_177230_c() instanceof BrewingStandBlock)) {
                return;
            }
            for (int i = 0; i < BrewingStandBlock.field_176451_a.length; ++i) {
                blockState = (BlockState)blockState.func_206870_a((Property)BrewingStandBlock.field_176451_a[i], (Comparable)Boolean.valueOf(bls[i]));
            }
            this.field_145850_b.func_180501_a(this.field_174879_c, blockState, 2);
        }
    }

    public boolean[] getSlotsEmpty() {
        boolean[] bls = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            if (((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
            bls[i] = true;
        }
        return bls;
    }

    private boolean canCraft() {
        ItemStack source = (ItemStack)this.inventory.get(3);
        if (source.func_190926_b()) {
            return false;
        }
        if (!BrewingRecipeRegistry.isValidIngredient((ItemStack)source)) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            ItemStack bottle = (ItemStack)this.inventory.get(i);
            if (bottle.func_190926_b()) continue;
            if (BrewingRecipeRegistry.hasOutput((ItemStack)bottle, (ItemStack)source)) {
                return true;
            }
            if (BrewingRegistry.getResult(source, bottle) == null) continue;
            return true;
        }
        return false;
    }

    private void craft() {
        ItemStack source = (ItemStack)this.inventory.get(3);
        for (int i = 0; i < 3; ++i) {
            ItemStack bottle = (ItemStack)this.inventory.get(i);
            if (bottle.func_190926_b()) continue;
            ItemStack result = BrewingRegistry.getResult(source, bottle);
            if (result != null) {
                this.inventory.set(i, (Object)result.func_77946_l());
                continue;
            }
            this.inventory.set(i, (Object)PotionBrewing.func_185212_d((ItemStack)source, (ItemStack)((ItemStack)this.inventory.get(i))));
        }
        source.func_190918_g(1);
        BlockPos blockPos = this.func_174877_v();
        if (source.hasContainerItem()) {
            ItemStack itemStack2 = new ItemStack((IItemProvider)source.getContainerItem().func_77973_b());
            if (source.func_190926_b()) {
                source = itemStack2;
            } else if (!this.field_145850_b.field_72995_K) {
                InventoryHelper.func_180173_a((World)this.field_145850_b, (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), (ItemStack)itemStack2);
            }
        }
        this.inventory.set(3, (Object)source);
        this.field_145850_b.func_217379_c(1035, blockPos, 0);
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)tag, this.inventory);
        this.brewTime = tag.func_74765_d("BrewTime");
        this.fuel = tag.func_74771_c("Fuel");
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74777_a("BrewTime", (short)this.brewTime);
        ItemStackHelper.func_191282_a((CompoundNBT)tag, this.inventory);
        tag.func_74774_a("Fuel", (byte)this.fuel);
        return tag;
    }

    public ItemStack func_70301_a(int slot) {
        return slot >= 0 && slot < this.inventory.size() ? (ItemStack)this.inventory.get(slot) : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return ItemStackHelper.func_188382_a(this.inventory, (int)slot, (int)amount);
    }

    public ItemStack func_70304_b(int slot) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (slot >= 0 && slot < this.inventory.size()) {
            this.inventory.set(slot, (Object)stack);
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 3) {
            return BrewingRecipeRegistry.isValidIngredient((ItemStack)stack);
        }
        Item item = stack.func_77973_b();
        if (slot == 4) {
            return item == Items.field_151065_br;
        }
        return (item == Items.field_151068_bn || item == Items.field_185155_bH || item == Items.field_185156_bI || item == Items.field_151069_bo) && this.func_70301_a(slot).func_190926_b();
    }

    public int[] func_180463_a(Direction side) {
        if (side == Direction.UP) {
            return TOP_SLOTS;
        }
        return side == Direction.DOWN ? BOTTOM_SLOTS : SIDE_SLOTS;
    }

    public boolean func_180462_a(int slot, ItemStack stack, @Nullable Direction dir) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, Direction dir) {
        if (slot == 3) {
            return stack.func_77973_b() == Items.field_151069_bo;
        }
        return true;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    protected Container func_213906_a(int syncId, PlayerInventory playerInventory) {
        return new BrewingStandContainer(syncId, playerInventory, (IInventory)this, this.propertyDelegate);
    }
}

