/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.structures.plants;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.MHelper;
import someoneelse.betternetherreforged.blocks.BlockPlantWall;
import someoneelse.betternetherreforged.blocks.BlockWillowBranch;
import someoneelse.betternetherreforged.blocks.BlockWillowLeaves;
import someoneelse.betternetherreforged.registry.BlocksRegistry;
import someoneelse.betternetherreforged.structures.StructureFuncScatter;

public class StructureOldWillow
extends StructureFuncScatter {
    private static final float[] CURVE_X = new float[]{9.0f, 7.0f, 1.5f, 0.5f, 3.0f, 7.0f};
    private static final float[] CURVE_Y = new float[]{20.0f, 17.0f, 12.0f, 4.0f, 0.0f, -2.0f};
    private static final Set<BlockPos> BLOCKS = new HashSet<BlockPos>();
    private Block[] wallPlants;

    public StructureOldWillow() {
        super(13);
    }

    @Override
    public void grow(IServerWorld world, BlockPos pos, Random random) {
        this.grow(world, pos, random, true);
    }

    public void grow(IServerWorld world, BlockPos pos, Random random, boolean natural) {
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 0);
        float scale = MHelper.randRange(0.7f, 1.3f, random);
        int minCount = scale < 1.0f ? 3 : 4;
        int maxCount = scale < 1.0f ? 5 : 7;
        int count = MHelper.randRange(minCount, maxCount, random);
        for (int n = 0; n < count; ++n) {
            float branchSize = MHelper.randRange(0.5f, 1.0f, random) * scale;
            float angle = (float)n * ((float)Math.PI * 2) / (float)count;
            float radius = CURVE_X[0] * branchSize;
            int x1 = Math.round((float)pos.func_177958_n() + radius * (float)Math.cos(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            int y1 = Math.round((float)pos.func_177956_o() + CURVE_Y[0] * branchSize + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            int z1 = Math.round((float)pos.func_177952_p() + radius * (float)Math.sin(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            float crownR = 10.0f * branchSize;
            if (crownR < 1.5f) {
                crownR = 1.5f;
            }
            this.crown((IWorld)world, new BlockPos(x1, y1 + 1, z1), crownR, random);
            boolean generate = true;
            for (int i = 1; i < CURVE_X.length && generate; ++i) {
                radius = CURVE_X[i] * branchSize;
                int x2 = Math.round((float)pos.func_177958_n() + radius * (float)Math.cos(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
                int y2 = Math.round((float)pos.func_177956_o() + CURVE_Y[i] * branchSize + (CURVE_Y[i] > 0.0f ? MHelper.randRange(-2.0f, 2.0f, random) * branchSize : 0.0f));
                int z2 = Math.round((float)pos.func_177952_p() + radius * (float)Math.sin(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
                if (CURVE_Y[i] <= 0.0f && !this.isGround(world.func_180495_p((BlockPos)POS.func_181079_c(x2, y2, z2)))) {
                    boolean noGround = true;
                    for (int d = 1; d < 3; ++d) {
                        if (!this.isGround(world.func_180495_p((BlockPos)POS.func_181079_c(x2, y2 - d, z2)))) continue;
                        y2 -= d;
                        noGround = false;
                        break;
                    }
                    if (noGround) {
                        x2 = pos.func_177958_n();
                        y2 = pos.func_177956_o();
                        generate = false;
                    }
                }
                this.line((IWorld)world, x1, y1, z1, x2, y2, z2, pos.func_177956_o());
                x1 = x2;
                y1 = y2;
                z1 = z2;
            }
        }
        if (this.wallPlants == null) {
            this.wallPlants = new Block[]{BlocksRegistry.WALL_MOSS, BlocksRegistry.WALL_MOSS, BlocksRegistry.WALL_MUSHROOM_BROWN, BlocksRegistry.WALL_MUSHROOM_RED};
        }
        for (BlockPos bpos : BLOCKS) {
            BlockState state = world.func_180495_p(bpos);
            if (!BlocksHelper.isNetherGround(state) && !state.func_185904_a().func_76222_j()) continue;
            if (!BLOCKS.contains(bpos.func_177984_a()) || !BLOCKS.contains(bpos.func_177977_b())) {
                BlocksHelper.setWithUpdate((IWorld)world, bpos, BlocksRegistry.WILLOW_BARK.func_176223_P());
            } else {
                BlocksHelper.setWithUpdate((IWorld)world, bpos, BlocksRegistry.WILLOW_LOG.func_176223_P());
            }
            if (random.nextInt(8) != 0) continue;
            state = this.wallPlants[random.nextInt(this.wallPlants.length)].func_176223_P();
            if (random.nextInt(8) == 0 && !BLOCKS.contains(bpos.func_177978_c()) && world.func_175623_d(bpos.func_177978_c())) {
                BlocksHelper.setWithUpdate((IWorld)world, bpos.func_177978_c(), (BlockState)state.func_206870_a((Property)BlockPlantWall.FACING, (Comparable)Direction.NORTH));
            }
            if (random.nextInt(8) == 0 && !BLOCKS.contains(bpos.func_177968_d()) && world.func_175623_d(bpos.func_177968_d())) {
                BlocksHelper.setWithUpdate((IWorld)world, bpos.func_177968_d(), (BlockState)state.func_206870_a((Property)BlockPlantWall.FACING, (Comparable)Direction.SOUTH));
            }
            if (random.nextInt(8) == 0 && !BLOCKS.contains(bpos.func_177974_f()) && world.func_175623_d(bpos.func_177974_f())) {
                BlocksHelper.setWithUpdate((IWorld)world, bpos.func_177974_f(), (BlockState)state.func_206870_a((Property)BlockPlantWall.FACING, (Comparable)Direction.EAST));
            }
            if (random.nextInt(8) != 0 || BLOCKS.contains(bpos.func_177976_e()) || !world.func_175623_d(bpos.func_177976_e())) continue;
            BlocksHelper.setWithUpdate((IWorld)world, bpos.func_177976_e(), (BlockState)state.func_206870_a((Property)BlockPlantWall.FACING, (Comparable)Direction.WEST));
        }
        BLOCKS.clear();
    }

    @Override
    public void generate(IServerWorld world, BlockPos pos, Random random) {
        int length = BlocksHelper.upRay((IWorld)world, pos, 27);
        if (length >= 25) {
            super.generate(world, pos, random);
        }
    }

    @Override
    protected boolean isStructure(BlockState state) {
        return state.func_177230_c() == BlocksRegistry.RUBEUS_LOG;
    }

    @Override
    protected boolean isGround(BlockState state) {
        return BlocksHelper.isNetherGround(state);
    }

    private void line(IWorld world, int x1, int y1, int z1, int x2, int y2, int z2, int startY) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        int mx = Math.max(Math.max(Math.abs(dx), Math.abs(dy)), Math.abs(dz));
        float fdx = (float)dx / (float)mx;
        float fdy = (float)dy / (float)mx;
        float fdz = (float)dz / (float)mx;
        float px = x1;
        float py = y1;
        float pz = z1;
        BlockPos pos = POS.func_181079_c(x1, y1, z1).func_185334_h();
        BLOCKS.add(pos);
        pos = POS.func_181079_c(x2, y2, z2).func_185334_h();
        BLOCKS.add(pos);
        for (int i = 0; i < mx; ++i) {
            POS.func_181079_c(Math.round(px += fdx), Math.round(py += fdy), Math.round(pz += fdz));
            double delta = POS.func_177956_o() - startY;
            this.sphere((BlockPos)POS, MathHelper.func_151237_a((double)(2.3 - Math.abs(delta) * (delta > 0.0 ? 0.1 : 0.3)), (double)0.5, (double)2.3));
        }
    }

    private void sphere(BlockPos pos, double radius) {
        int x1 = MHelper.floor((double)pos.func_177958_n() - radius);
        int y1 = MHelper.floor((double)pos.func_177956_o() - radius);
        int z1 = MHelper.floor((double)pos.func_177952_p() - radius);
        int x2 = MHelper.floor((double)pos.func_177958_n() + radius + 1.0);
        int y2 = MHelper.floor((double)pos.func_177956_o() + radius + 1.0);
        int z2 = MHelper.floor((double)pos.func_177952_p() + radius + 1.0);
        radius *= radius;
        for (int x = x1; x <= x2; ++x) {
            int px2 = x - pos.func_177958_n();
            px2 *= px2;
            for (int z = z1; z <= z2; ++z) {
                int pz2 = z - pos.func_177952_p();
                pz2 *= pz2;
                for (int y = y1; y <= y2; ++y) {
                    int py2 = y - pos.func_177956_o();
                    if (!((double)(px2 + pz2 + (py2 *= py2)) <= radius)) continue;
                    BLOCKS.add(new BlockPos(x, y, z));
                }
            }
        }
    }

    private void crown(IWorld world, BlockPos pos, float radius, Random random) {
        int start;
        BlockState leaves = (BlockState)BlocksRegistry.WILLOW_LEAVES.func_176223_P().func_206870_a((Property)BlockWillowLeaves.NATURAL, (Comparable)Boolean.valueOf(false));
        BlockState vine = BlocksRegistry.WILLOW_BRANCH.func_176223_P();
        float halfR = radius * 0.5f;
        float r2 = radius * radius;
        int cy = start = (int)Math.floor(-radius);
        while ((float)cy <= radius) {
            int cy2_out = cy * cy;
            float cy2_in = (float)cy + halfR;
            cy2_in *= cy2_in;
            POS.func_185336_p((int)((float)(pos.func_177956_o() + cy) - halfR));
            int cx = start;
            while ((float)cx <= radius) {
                int cx2 = cx * cx * 2;
                POS.func_223471_o(pos.func_177958_n() + cx);
                int cz = start;
                while ((float)cz <= radius) {
                    block5: {
                        block8: {
                            block6: {
                                int length;
                                block7: {
                                    int cz2 = cz * cz * 2;
                                    if (!((float)(cx2 + cy2_out + cz2) < r2) || !((float)cx2 + cy2_in + (float)cz2 > r2)) break block5;
                                    POS.func_223472_q(pos.func_177952_p() + cz);
                                    if (!world.func_180495_p((BlockPos)POS).func_185904_a().func_76222_j()) break block5;
                                    if (!random.nextBoolean()) break block6;
                                    length = BlocksHelper.downRay(world, (BlockPos)POS, 12);
                                    if (length >= 3) break block7;
                                    BlocksHelper.setWithUpdate(world, (BlockPos)POS, leaves);
                                    break block5;
                                }
                                length = MHelper.randRange(3, length, random);
                                for (int i = 1; i < length - 1; ++i) {
                                    BlocksHelper.setWithUpdate(world, POS.func_177979_c(i), vine);
                                }
                                BlocksHelper.setWithUpdate(world, POS.func_177979_c(length - 1), (BlockState)vine.func_206870_a(BlockWillowBranch.SHAPE, (Comparable)((Object)BlockWillowBranch.WillowBranchShape.END)));
                                break block8;
                            }
                            if (random.nextBoolean() && world.func_180495_p(POS.func_177977_b()).func_185904_a().func_76222_j()) {
                                BlocksHelper.setWithUpdate(world, POS.func_177977_b(), leaves);
                            }
                        }
                        BlocksHelper.setWithUpdate(world, (BlockPos)POS, leaves);
                    }
                    ++cz;
                }
                ++cx;
            }
            ++cy;
        }
    }
}

