/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.structures;

import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.structures.IStructure;
import someoneelse.betternetherreforged.structures.StructureNBT;
import someoneelse.betternetherreforged.structures.StructureType;

public class StructureWorld
extends StructureNBT
implements IStructure {
    protected static final BlockPos.Mutable POS = new BlockPos.Mutable();
    protected final StructureType type;
    protected final int offsetY;

    public StructureWorld(String structure, int offsetY, StructureType type) {
        super(structure);
        this.offsetY = offsetY;
        this.type = type;
    }

    @Override
    public void generate(IServerWorld world, BlockPos pos, Random random) {
        this.randomRM(random);
        if (this.canGenerate((IWorld)world, pos)) {
            this.generateCentered(world, pos.func_177981_b(this.offsetY));
        }
    }

    private boolean canGenerate(IWorld world, BlockPos pos) {
        for (int i = 0; i < this.structure.func_186259_a().func_177956_o(); i += 2) {
            if (!world.func_180495_p(pos.func_177981_b(i)).func_203425_a(Blocks.field_150357_h)) continue;
            return false;
        }
        if (this.type == StructureType.FLOOR) {
            return (double)this.getAirFraction(world, pos) > 0.6 && (double)this.getAirFractionFoundation(world, pos) < 0.5;
        }
        if (this.type == StructureType.LAVA) {
            return (double)this.getLavaFractionFoundation(world, pos) > 0.9 && (double)this.getAirFraction(world, pos) > 0.9;
        }
        if (this.type == StructureType.UNDER) {
            return (double)this.getAirFraction(world, pos) < 0.2;
        }
        if (this.type == StructureType.CEIL) {
            return (double)this.getAirFractionBottom(world, pos) > 0.8 && (double)this.getAirFraction(world, pos) < 0.6;
        }
        return false;
    }

    private float getAirFraction(IWorld world, BlockPos pos) {
        int airCount = 0;
        BlockPos.Mutable size = new BlockPos.Mutable().func_189533_g((Vector3i)this.structure.func_186259_a().func_190942_a(this.rotation));
        size.func_223471_o(Math.abs(size.func_177958_n()));
        size.func_223472_q(Math.abs(size.func_177952_p()));
        BlockPos start = pos.func_177982_a(-(size.func_177958_n() >> 1), 0, -(size.func_177952_p() >> 1));
        BlockPos end = pos.func_177982_a(size.func_177958_n() >> 1, size.func_177956_o() + this.offsetY, size.func_177952_p() >> 1);
        int count = 0;
        for (int x = start.func_177958_n(); x <= end.func_177958_n(); ++x) {
            POS.func_223471_o(x);
            for (int y = start.func_177956_o(); y <= end.func_177956_o(); ++y) {
                POS.func_185336_p(y);
                for (int z = start.func_177952_p(); z <= end.func_177952_p(); ++z) {
                    POS.func_223472_q(z);
                    if (world.func_175623_d((BlockPos)POS)) {
                        ++airCount;
                    }
                    ++count;
                }
            }
        }
        return (float)airCount / (float)count;
    }

    private float getLavaFractionFoundation(IWorld world, BlockPos pos) {
        int lavaCount = 0;
        BlockPos.Mutable size = new BlockPos.Mutable().func_189533_g((Vector3i)this.structure.func_186259_a().func_190942_a(this.rotation));
        size.func_223471_o(Math.abs(size.func_177958_n()));
        size.func_223472_q(Math.abs(size.func_177952_p()));
        BlockPos start = pos.func_177982_a(-(size.func_177958_n() >> 1), 0, -(size.func_177952_p() >> 1));
        BlockPos end = pos.func_177982_a(size.func_177958_n() >> 1, 0, size.func_177952_p() >> 1);
        int count = 0;
        POS.func_185336_p(pos.func_177956_o() - 1);
        for (int x = start.func_177958_n(); x <= end.func_177958_n(); ++x) {
            POS.func_223471_o(x);
            for (int z = start.func_177952_p(); z <= end.func_177952_p(); ++z) {
                POS.func_223472_q(z);
                if (BlocksHelper.isLava(world.func_180495_p((BlockPos)POS))) {
                    ++lavaCount;
                }
                ++count;
            }
        }
        return (float)lavaCount / (float)count;
    }

    private float getAirFractionFoundation(IWorld world, BlockPos pos) {
        int airCount = 0;
        BlockPos.Mutable size = new BlockPos.Mutable().func_189533_g((Vector3i)this.structure.func_186259_a().func_190942_a(this.rotation));
        size.func_223471_o(Math.abs(size.func_177958_n()));
        size.func_223472_q(Math.abs(size.func_177952_p()));
        BlockPos start = pos.func_177982_a(-(size.func_177958_n() >> 1), -1, -(size.func_177952_p() >> 1));
        BlockPos end = pos.func_177982_a(size.func_177958_n() >> 1, 0, size.func_177952_p() >> 1);
        int count = 0;
        for (int x = start.func_177958_n(); x <= end.func_177958_n(); ++x) {
            POS.func_223471_o(x);
            for (int y = start.func_177956_o(); y <= end.func_177956_o(); ++y) {
                POS.func_185336_p(y);
                for (int z = start.func_177952_p(); z <= end.func_177952_p(); ++z) {
                    POS.func_223472_q(z);
                    if (world.func_180495_p((BlockPos)POS).func_185904_a().func_76222_j()) {
                        ++airCount;
                    }
                    ++count;
                }
            }
        }
        return (float)airCount / (float)count;
    }

    private float getAirFractionBottom(IWorld world, BlockPos pos) {
        int airCount = 0;
        BlockPos.Mutable size = new BlockPos.Mutable().func_189533_g((Vector3i)this.structure.func_186259_a().func_190942_a(this.rotation));
        size.func_223471_o(Math.abs(size.func_177958_n()));
        size.func_223472_q(Math.abs(size.func_177952_p()));
        float y1 = Math.min(this.offsetY, 0);
        float y2 = Math.max(this.offsetY, 0);
        BlockPos start = pos.func_177963_a((double)(-(size.func_177958_n() >> 1)), (double)y1, (double)(-(size.func_177952_p() >> 1)));
        BlockPos end = pos.func_177963_a((double)(size.func_177958_n() >> 1), (double)y2, (double)(size.func_177952_p() >> 1));
        int count = 0;
        for (int x = start.func_177958_n(); x <= end.func_177958_n(); ++x) {
            POS.func_223471_o(x);
            for (int y = start.func_177956_o(); y <= end.func_177956_o(); ++y) {
                POS.func_185336_p(y);
                for (int z = start.func_177952_p(); z <= end.func_177952_p(); ++z) {
                    POS.func_223472_q(z);
                    if (world.func_180495_p((BlockPos)POS).func_185904_a().func_76222_j()) {
                        ++airCount;
                    }
                    ++count;
                }
            }
        }
        return (float)airCount / (float)count;
    }

    public boolean loaded() {
        return this.structure != null;
    }

    public StructureType getType() {
        return this.type;
    }
}

