/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.structures;

import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;

public class StructureNBT {
    protected ResourceLocation location;
    protected Template structure;
    protected Mirror mirror = Mirror.NONE;
    protected Rotation rotation = Rotation.NONE;

    public StructureNBT(String structure) {
        this.location = new ResourceLocation("betternether", structure);
        this.structure = this.readStructureFromJar(this.location);
    }

    protected StructureNBT(ResourceLocation location, Template structure) {
        this.location = location;
        this.structure = structure;
    }

    public StructureNBT setRotation(Rotation rotation) {
        this.rotation = rotation;
        return this;
    }

    public Mirror getMirror() {
        return this.mirror;
    }

    public StructureNBT setMirror(Mirror mirror) {
        this.mirror = mirror;
        return this;
    }

    public void randomRM(Random random) {
        this.rotation = Rotation.values()[random.nextInt(4)];
        this.mirror = Mirror.values()[random.nextInt(3)];
    }

    public boolean generateCentered(IServerWorld world, BlockPos pos) {
        if (this.structure == null) {
            System.out.println("No structure: " + this.location.toString());
            return false;
        }
        BlockPos.Mutable blockpos2 = new BlockPos.Mutable().func_189533_g((Vector3i)this.structure.func_186259_a());
        if (this.mirror == Mirror.FRONT_BACK) {
            blockpos2.func_223471_o(-blockpos2.func_177958_n());
        }
        if (this.mirror == Mirror.LEFT_RIGHT) {
            blockpos2.func_223472_q(-blockpos2.func_177952_p());
        }
        blockpos2.func_189533_g((Vector3i)blockpos2.func_190942_a(this.rotation));
        PlacementSettings data = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(this.mirror);
        this.structure.func_237144_a_(world, pos.func_177982_a(-blockpos2.func_177958_n() >> 1, 0, -blockpos2.func_177952_p() >> 1), data, world.func_201674_k());
        return true;
    }

    private Template readStructureFromJar(ResourceLocation resource) {
        String ns = resource.func_110624_b();
        String nm = resource.func_110623_a();
        try {
            InputStream inputstream = MinecraftServer.class.getResourceAsStream("/data/" + ns + "/structures/" + nm + ".nbt");
            return this.readStructureFromStream(inputstream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Template readStructureFromStream(InputStream stream) throws IOException {
        CompoundNBT nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)stream);
        Template template = new Template();
        template.func_186256_b(nbttagcompound);
        return template;
    }

    public BlockPos getSize() {
        if (this.rotation == Rotation.NONE || this.rotation == Rotation.CLOCKWISE_180) {
            return this.structure.func_186259_a();
        }
        BlockPos size = this.structure.func_186259_a();
        int x = size.func_177958_n();
        int z = size.func_177952_p();
        return new BlockPos(z, size.func_177956_o(), x);
    }

    public String getName() {
        return this.location.func_110623_a();
    }

    public MutableBoundingBox getBoundingBox(BlockPos pos) {
        return this.structure.func_215388_b(new PlacementSettings().func_186220_a(this.rotation).func_186214_a(this.mirror), pos);
    }
}

