/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.registry;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;
import someoneelse.betternetherreforged.blocks.BNBarrel;
import someoneelse.betternetherreforged.blocks.BNChest;
import someoneelse.betternetherreforged.blocks.BNSign;
import someoneelse.betternetherreforged.blocks.BlockNetherFurnace;
import someoneelse.betternetherreforged.registry.BlocksRegistry;
import someoneelse.betternetherreforged.tileentities.BNBarrelTileEntity;
import someoneelse.betternetherreforged.tileentities.BNBrewingStandTileEntity;
import someoneelse.betternetherreforged.tileentities.BNChestTileEntity;
import someoneelse.betternetherreforged.tileentities.BNSignTileEntity;
import someoneelse.betternetherreforged.tileentities.TileEntityChestOfDrawers;
import someoneelse.betternetherreforged.tileentities.TileEntityForge;
import someoneelse.betternetherreforged.tileentities.TileEntityFurnace;

public class TileEntitiesRegistry {
    public static final DeferredRegister<TileEntityType<?>> DEFERRED = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"betternether");
    private static final List<Pair<String, TileEntityType<?>>> MODTILES = new ArrayList();
    public static final TileEntityType<?> CINCINNASITE_FORGE = TileEntitiesRegistry.registerTileEntity("forge", TileEntityType.Builder.func_223042_a(TileEntityForge::new, (Block[])new Block[]{BlocksRegistry.CINCINNASITE_FORGE}).func_206865_a(null));
    public static final TileEntityType<?> NETHERRACK_FURNACE = TileEntitiesRegistry.registerTileEntity("furnace", TileEntityType.Builder.func_223042_a(TileEntityFurnace::new, (Block[])TileEntitiesRegistry.getFurnaces()).func_206865_a(null));
    public static final TileEntityType<?> CHEST_OF_DRAWERS = TileEntitiesRegistry.registerTileEntity("chest_of_drawers", TileEntityType.Builder.func_223042_a(TileEntityChestOfDrawers::new, (Block[])new Block[]{BlocksRegistry.CHEST_OF_DRAWERS}).func_206865_a(null));
    public static final TileEntityType<?> NETHER_BREWING_STAND = TileEntitiesRegistry.registerTileEntity("nether_brewing_stand", TileEntityType.Builder.func_223042_a(BNBrewingStandTileEntity::new, (Block[])new Block[]{BlocksRegistry.NETHER_BREWING_STAND}).func_206865_a(null));
    public static final TileEntityType<BNChestTileEntity> CHEST = TileEntitiesRegistry.registerTileEntity("chest", TileEntityType.Builder.func_223042_a(BNChestTileEntity::new, (Block[])TileEntitiesRegistry.getChests()).func_206865_a(null));
    public static final TileEntityType<BNBarrelTileEntity> BARREL = TileEntitiesRegistry.registerTileEntity("barrel", TileEntityType.Builder.func_223042_a(BNBarrelTileEntity::new, (Block[])TileEntitiesRegistry.getBarrels()).func_206865_a(null));
    public static final TileEntityType<BNSignTileEntity> SIGN = TileEntitiesRegistry.registerTileEntity("sign", TileEntityType.Builder.func_223042_a(BNSignTileEntity::new, (Block[])TileEntitiesRegistry.getSigns()).func_206865_a(null));

    public static <T extends TileEntity> TileEntityType<T> registerTileEntity(String name, TileEntityType<T> type) {
        MODTILES.add(Pair.of((Object)name, type));
        return type;
    }

    public static void registerAll(RegistryEvent.Register<TileEntityType<?>> e) {
        IForgeRegistry r = e.getRegistry();
        for (Pair<String, TileEntityType<?>> tile : MODTILES) {
            r.register(((TileEntityType)tile.getRight()).setRegistryName(new ResourceLocation("betternether", (String)tile.getLeft())));
        }
    }

    private static Block[] getChests() {
        ArrayList result = new ArrayList();
        BlocksRegistry.getPossibleBlocks().forEach(block -> {
            if (block instanceof BNChest) {
                result.add(block);
            }
        });
        return result.toArray(new Block[0]);
    }

    private static Block[] getBarrels() {
        ArrayList result = new ArrayList();
        BlocksRegistry.getPossibleBlocks().forEach(block -> {
            if (block instanceof BNBarrel) {
                result.add(block);
            }
        });
        return result.toArray(new Block[0]);
    }

    private static Block[] getSigns() {
        ArrayList result = new ArrayList();
        BlocksRegistry.getPossibleBlocks().forEach(block -> {
            if (block instanceof BNSign) {
                result.add(block);
            }
        });
        return result.toArray(new Block[0]);
    }

    private static Block[] getFurnaces() {
        ArrayList result = new ArrayList();
        BlocksRegistry.getPossibleBlocks().forEach(block -> {
            if (block instanceof BlockNetherFurnace) {
                result.add(block);
            }
        });
        return result.toArray(new Block[0]);
    }
}

