/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import someoneelse.betternetherreforged.config.Configs;
import someoneelse.betternetherreforged.entity.EntityChair;
import someoneelse.betternetherreforged.entity.EntityFirefly;
import someoneelse.betternetherreforged.entity.EntityFlyingPig;
import someoneelse.betternetherreforged.entity.EntityHydrogenJellyfish;
import someoneelse.betternetherreforged.entity.EntityJungleSkeleton;
import someoneelse.betternetherreforged.entity.EntityNaga;
import someoneelse.betternetherreforged.entity.EntityNagaProjectile;
import someoneelse.betternetherreforged.entity.EntitySkull;

@Mod.EventBusSubscriber(modid="betternether", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EntityRegistry {
    public static final Map<EntityType<? extends LivingEntity>, AttributeModifierMap> ATTRIBUTES = Maps.newHashMap();
    private static final List<EntityType<?>> NETHER_ENTITIES = Lists.newArrayList();
    public static final DeferredRegister<EntityType<?>> DEFERRED = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"betternether");
    public static final EntityType<EntityChair> CHAIR = EntityType.Builder.func_220322_a(EntityChair::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.0f, 0.0f).setUpdateInterval(3).setTrackingRange(5).func_200705_b().func_220320_c().setShouldReceiveVelocityUpdates(true).func_206830_a("");
    public static final EntityType<EntityNagaProjectile> NAGA_PROJECTILE = EntityType.Builder.func_220322_a(EntityNagaProjectile::new, (EntityClassification)EntityClassification.MISC).func_220321_a(1.0f, 1.0f).setUpdateInterval(3).setTrackingRange(5).func_200705_b().setShouldReceiveVelocityUpdates(true).func_206830_a("");
    public static final EntityType<EntityFirefly> FIREFLY = EntityType.Builder.func_220322_a(EntityFirefly::new, (EntityClassification)EntityClassification.AMBIENT).func_220321_a(0.5f, 0.5f).setUpdateInterval(3).setTrackingRange(5).func_220320_c().setShouldReceiveVelocityUpdates(true).func_206830_a("");
    public static final EntityType<EntityHydrogenJellyfish> HYDROGEN_JELLYFISH = EntityType.Builder.func_220322_a(EntityHydrogenJellyfish::new, (EntityClassification)EntityClassification.AMBIENT).func_220321_a(2.0f, 5.0f).setUpdateInterval(3).setTrackingRange(5).func_220320_c().setShouldReceiveVelocityUpdates(true).func_206830_a("");
    public static final EntityType<EntityNaga> NAGA = EntityType.Builder.func_220322_a(EntityNaga::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.625f, 2.75f).setUpdateInterval(3).setTrackingRange(5).func_220320_c().setShouldReceiveVelocityUpdates(true).func_206830_a("");
    public static final EntityType<EntityFlyingPig> FLYING_PIG = EntityType.Builder.func_220322_a(EntityFlyingPig::new, (EntityClassification)EntityClassification.AMBIENT).func_220321_a(1.0f, 1.25f).setUpdateInterval(3).setTrackingRange(5).func_220320_c().setShouldReceiveVelocityUpdates(true).func_206830_a("");
    public static final EntityType<EntityJungleSkeleton> JUNGLE_SKELETON = EntityType.Builder.func_220322_a(EntityJungleSkeleton::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.99f).setUpdateInterval(3).setTrackingRange(5).func_220320_c().setShouldReceiveVelocityUpdates(true).func_206830_a("");
    public static final EntityType<EntitySkull> SKULL = EntityType.Builder.func_220322_a(EntitySkull::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.625f, 0.625f).setUpdateInterval(3).setTrackingRange(5).func_220320_c().setShouldReceiveVelocityUpdates(true).func_206830_a("");

    public static void registerAll(RegistryEvent.Register<EntityType<?>> evt) {
        IForgeRegistry r = evt.getRegistry();
        r.register(CHAIR.setRegistryName(new ResourceLocation("betternether", "chair")));
        if (Configs.MOBS.getBoolean("mobs", "naga", true)) {
            r.register(NAGA_PROJECTILE.setRegistryName(new ResourceLocation("betternether", "naga_projectile")));
        }
        if (Configs.MOBS.getBoolean("mobs", "firefly", true)) {
            r.register(FIREFLY.setRegistryName(new ResourceLocation("betternether", "firefly")));
        }
        if (Configs.MOBS.getBoolean("mobs", "naga", true)) {
            r.register(NAGA.setRegistryName(new ResourceLocation("betternether", "naga")));
        }
        if (Configs.MOBS.getBoolean("mobs", "flying_pig", true)) {
            r.register(FLYING_PIG.setRegistryName(new ResourceLocation("betternether", "flying_pig")));
        }
        if (Configs.MOBS.getBoolean("mobs", "jungle_skeleton", true)) {
            r.register(JUNGLE_SKELETON.setRegistryName(new ResourceLocation("betternether", "jungle_skeleton")));
        }
        if (Configs.MOBS.getBoolean("mobs", "hydrogen_jellyfish", true)) {
            r.register(HYDROGEN_JELLYFISH.setRegistryName(new ResourceLocation("betternether", "hydrogen_jellyfish")));
        }
        if (Configs.MOBS.getBoolean("mobs", "skull", true)) {
            r.register(SKULL.setRegistryName(new ResourceLocation("betternether", "skull")));
        }
        EntityRegistry.registerEntityAttributes();
        EntityRegistry.registerSpawnPlacementData();
    }

    public static void registerSpawnPlacementData() {
        EntitySpawnPlacementRegistry.func_209343_a(NAGA, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntityNaga::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(HYDROGEN_JELLYFISH, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntityHydrogenJellyfish::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(JUNGLE_SKELETON, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntityJungleSkeleton::canSpawn);
    }

    public static void registerEntityAttributes() {
        GlobalEntityTypeAttributes.put(CHAIR, (AttributeModifierMap)EntityChair.getAttributeContainer());
        GlobalEntityTypeAttributes.put(NAGA_PROJECTILE, (AttributeModifierMap)MobEntity.func_233666_p_().func_233813_a_());
        GlobalEntityTypeAttributes.put(FIREFLY, (AttributeModifierMap)EntityFirefly.getAttributeContainer());
        GlobalEntityTypeAttributes.put(NAGA, (AttributeModifierMap)EntityNaga.getAttributeContainer());
        GlobalEntityTypeAttributes.put(FLYING_PIG, (AttributeModifierMap)EntityFlyingPig.getAttributeContainer());
        GlobalEntityTypeAttributes.put(JUNGLE_SKELETON, (AttributeModifierMap)AbstractSkeletonEntity.func_234275_m_().func_233813_a_());
        GlobalEntityTypeAttributes.put(HYDROGEN_JELLYFISH, (AttributeModifierMap)EntityHydrogenJellyfish.getAttributeContainer());
        GlobalEntityTypeAttributes.put(SKULL, (AttributeModifierMap)EntitySkull.getAttributeContainer());
    }

    public static void registerNetherEntities() {
        NETHER_ENTITIES.add(EntityType.field_200811_y);
        NETHER_ENTITIES.add(EntityType.field_233592_ba_);
        NETHER_ENTITIES.add(EntityType.field_233591_ai_);
        NETHER_ENTITIES.add(EntityType.field_233588_G_);
        NETHER_ENTITIES.add(EntityType.field_200792_f);
        NETHER_ENTITIES.add(EntityType.field_233589_aE_);
    }

    public static void registerEntity(String name, EntityType<? extends LivingEntity> entity) {
        if (Configs.MOBS.getBoolean("mobs", name, true)) {
            Registry.func_218322_a((Registry)Registry.field_212629_r, (ResourceLocation)new ResourceLocation("betternether", name), entity);
            ATTRIBUTES.put(entity, MobEntity.func_233639_cI_().func_233813_a_());
        }
    }

    public static void registerEntity(String name, EntityType<? extends LivingEntity> entity, AttributeModifierMap container) {
        if (Configs.MOBS.getBoolean("mobs", name, true)) {
            Registry.func_218322_a((Registry)Registry.field_212629_r, (ResourceLocation)new ResourceLocation("betternether", name), entity);
            ATTRIBUTES.put(entity, container);
        }
    }

    public static boolean isNetherEntity(Entity entity) {
        return NETHER_ENTITIES.contains(entity.func_200600_R());
    }
}

