/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.registry;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import someoneelse.betternetherreforged.registry.BlocksRegistry;

public class BrewingRegistry {
    private static final List<BrewingRecipe> RECIPES = new ArrayList<BrewingRecipe>();

    public static void register() {
        BrewingRegistry.register(new ItemStack((IItemProvider)BlocksRegistry.BARREL_CACTUS), new ItemStack((IItemProvider)Items.field_151069_bo), BrewingRegistry.makePotion(Potions.field_185230_b));
        BrewingRegistry.register(new ItemStack((IItemProvider)BlocksRegistry.HOOK_MUSHROOM), BrewingRegistry.makePotion(Potions.field_185233_e), BrewingRegistry.makePotion(Potions.field_185250_v));
    }

    private static void register(ItemStack source, ItemStack bottle, ItemStack result) {
        RECIPES.add(new BrewingRecipe(source, bottle, result));
    }

    private static ItemStack makePotion(Potion potion) {
        return PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)potion);
    }

    public static ItemStack getResult(ItemStack source, ItemStack bottle) {
        for (BrewingRecipe recipe : RECIPES) {
            if (!recipe.isValid(source, bottle)) continue;
            return recipe.getResult();
        }
        return null;
    }

    public static boolean isValidIngridient(ItemStack source) {
        for (BrewingRecipe recipe : RECIPES) {
            if (!recipe.isValid(source)) continue;
            return true;
        }
        return false;
    }

    public static class BrewingRecipe {
        private final ItemStack source;
        private final ItemStack bottle;
        private final ItemStack result;

        public BrewingRecipe(ItemStack source, ItemStack bottle, ItemStack result) {
            this.source = source;
            this.bottle = bottle;
            this.result = result;
        }

        public boolean isValid(ItemStack source, ItemStack bottle) {
            return ItemStack.func_185132_d((ItemStack)this.source, (ItemStack)source) && ItemStack.func_185132_d((ItemStack)this.bottle, (ItemStack)bottle);
        }

        public boolean isValid(ItemStack source) {
            return ItemStack.func_185132_d((ItemStack)this.source, (ItemStack)source);
        }

        public ItemStack getResult() {
            return this.result;
        }
    }
}

