/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import someoneelse.betternetherreforged.entity.EntityNaga;

public class EntityNagaProjectile
extends FlyingEntity {
    private static final int MAX_LIFE_TIME = 60;
    private int lifeTime = 0;

    public EntityNagaProjectile(EntityType<? extends EntityNagaProjectile> type, World world) {
        super(type, world);
        this.field_70728_aV = 0;
    }

    public void setParams(LivingEntity owner, Entity target) {
        this.func_70107_b(this.func_226277_ct_(), this.func_226280_cw_() - (double)this.func_213302_cg(), this.func_226281_cx_());
        Vector3d dir = target.func_213303_ch().func_72441_c(0.0, (double)target.func_213302_cg() * 0.25, 0.0).func_178788_d(this.func_213303_ch()).func_72432_b().func_186678_a(2.0);
        this.func_213317_d(dir);
        this.field_70169_q = this.func_226277_ct_() - dir.field_72450_a;
        this.field_70167_r = this.func_226278_cu_() - dir.field_72448_b;
        this.field_70166_s = this.func_226281_cx_() - dir.field_72449_c;
    }

    public boolean func_189652_ae() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < 128.0;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, this.func_226277_ct_() + this.field_70146_Z.nextGaussian() * 0.2, this.func_226278_cu_() + this.field_70146_Z.nextGaussian() * 0.2, this.func_226281_cx_() + this.field_70146_Z.nextGaussian() * 0.2, 0.0, 0.0, 0.0);
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_() + this.field_70146_Z.nextGaussian() * 0.2, this.func_226278_cu_() + this.field_70146_Z.nextGaussian() * 0.2, this.func_226281_cx_() + this.field_70146_Z.nextGaussian() * 0.2, 0.0, 0.0, 0.0);
        RayTraceResult hitResult = ProjectileHelper.func_234618_a_((Entity)this, entity -> entity.func_70089_S() && entity instanceof LivingEntity);
        if (hitResult.func_216346_c() != RayTraceResult.Type.MISS) {
            this.onCollision(hitResult);
        }
        ++this.lifeTime;
        if (this.lifeTime > 60) {
            this.effectKill();
        }
        if (this.isSame(this.field_70169_q, this.func_226277_ct_()) && this.isSame(this.field_70167_r, this.func_226278_cu_()) && this.isSame(this.field_70166_s, this.func_226281_cx_())) {
            this.effectKill();
        }
    }

    private boolean isSame(double a, double b) {
        return Math.abs(a - b) < 0.1;
    }

    protected void onCollision(RayTraceResult hitResult) {
        Entity entity;
        RayTraceResult.Type type = hitResult.func_216346_c();
        if (type == RayTraceResult.Type.BLOCK) {
            for (int i = 0; i < 10; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, this.func_226277_ct_() + this.field_70146_Z.nextGaussian() * 0.5, this.func_226278_cu_() + this.field_70146_Z.nextGaussian() * 0.5, this.func_226281_cx_() + this.field_70146_Z.nextGaussian() * 0.5, this.field_70146_Z.nextGaussian() * 0.2, this.field_70146_Z.nextGaussian() * 0.2, this.field_70146_Z.nextGaussian() * 0.2);
            }
            this.effectKill();
        } else if (type == RayTraceResult.Type.ENTITY && (entity = ((EntityRayTraceResult)hitResult).func_216348_a()) != this && entity instanceof LivingEntity && !(entity instanceof EntityNaga)) {
            LivingEntity living = (LivingEntity)entity;
            if (!living.func_70644_a(Effects.field_82731_v)) {
                living.func_195064_c(new EffectInstance(Effects.field_82731_v, 40));
            }
            this.effectKill();
        }
    }

    private void effectKill() {
        for (int i = 0; i < 10; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.func_226277_ct_() + this.field_70146_Z.nextGaussian() * 0.5, this.func_226278_cu_() + this.field_70146_Z.nextGaussian() * 0.5, this.func_226281_cx_() + this.field_70146_Z.nextGaussian() * 0.5, 0.1, 0.1, 0.1);
        }
        this.func_174812_G();
    }

    public boolean func_70687_e(EffectInstance effect) {
        return false;
    }

    public boolean func_174814_R() {
        return true;
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74768_a("life", this.lifeTime);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("life")) {
            this.lifeTime = tag.func_74762_e("life");
        }
    }
}

