/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.blocks;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.MHelper;
import someoneelse.betternetherreforged.blocks.BNRenderLayer;
import someoneelse.betternetherreforged.blocks.BlockBaseNotFull;
import someoneelse.betternetherreforged.blocks.materials.MaterialBuilder;
import someoneelse.betternetherreforged.registry.BlocksRegistry;
import someoneelse.betternetherreforged.structures.plants.StructureSoulLily;

public class BlockSoulLily
extends BlockBaseNotFull {
    public static final EnumProperty<SoulLilyShape> SHAPE = EnumProperty.func_177709_a((String)"shape", SoulLilyShape.class);
    private static final VoxelShape SHAPE_SMALL = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_MEDIUM_BOTTOM = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape SHAPE_MEDIUM_TOP = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    private static final VoxelShape SHAPE_BIG_BOTTOM = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape SHAPE_BIG_MIDDLE = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_BIG_TOP_CENTER = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    private static final VoxelShape SHAPE_BIG_TOP_SIDE_N = Block.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)6.0, (double)8.0);
    private static final VoxelShape SHAPE_BIG_TOP_SIDE_S = Block.func_208617_a((double)0.0, (double)4.0, (double)8.0, (double)16.0, (double)6.0, (double)16.0);
    private static final VoxelShape SHAPE_BIG_TOP_SIDE_E = Block.func_208617_a((double)8.0, (double)4.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    private static final VoxelShape SHAPE_BIG_TOP_SIDE_W = Block.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)8.0, (double)6.0, (double)16.0);
    private static final StructureSoulLily STRUCTURE = new StructureSoulLily();
    private static final SoulLilyShape[] ROT = new SoulLilyShape[]{SoulLilyShape.BIG_TOP_SIDE_N, SoulLilyShape.BIG_TOP_SIDE_E, SoulLilyShape.BIG_TOP_SIDE_S, SoulLilyShape.BIG_TOP_SIDE_W};

    public BlockSoulLily() {
        super(MaterialBuilder.makeWood(MaterialColor.field_151676_q).func_226896_b_().func_200944_c());
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(SHAPE, (Comparable)((Object)SoulLilyShape.SMALL)));
        this.setRenderLayer(BNRenderLayer.CUTOUT);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> stateManager) {
        stateManager.func_206894_a(new Property[]{SHAPE});
    }

    public VoxelShape getOutlineShape(BlockState state, IBlockReader view, BlockPos pos, ISelectionContext ePos) {
        switch ((SoulLilyShape)((Object)state.func_177229_b(SHAPE))) {
            case BIG_BOTTOM: {
                return SHAPE_BIG_BOTTOM;
            }
            case BIG_MIDDLE: {
                return SHAPE_BIG_MIDDLE;
            }
            case BIG_TOP_CENTER: {
                return SHAPE_BIG_TOP_CENTER;
            }
            case MEDIUM_BOTTOM: {
                return SHAPE_MEDIUM_BOTTOM;
            }
            case MEDIUM_TOP: {
                return SHAPE_MEDIUM_TOP;
            }
            case BIG_TOP_SIDE_N: {
                return SHAPE_BIG_TOP_SIDE_N;
            }
            case BIG_TOP_SIDE_S: {
                return SHAPE_BIG_TOP_SIDE_S;
            }
            case BIG_TOP_SIDE_E: {
                return SHAPE_BIG_TOP_SIDE_E;
            }
            case BIG_TOP_SIDE_W: {
                return SHAPE_BIG_TOP_SIDE_W;
            }
        }
        return SHAPE_SMALL;
    }

    public boolean canGrow(World world, BlockPos pos, Random random) {
        BlockState state = world.func_180495_p(pos.func_177977_b());
        if (state.func_177230_c() == this || state.func_177230_c() == Blocks.field_150425_aM || BlocksHelper.isFertile(world.func_180495_p(pos.func_177977_b()))) {
            return BlocksHelper.isFertile(world.func_180495_p(pos.func_177977_b())) ? random.nextInt(8) == 0 : random.nextInt(16) == 0;
        }
        return false;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        super.func_225534_a_(state, world, pos, random);
        if (this.canGrow((World)world, pos, random)) {
            SoulLilyShape shape = (SoulLilyShape)((Object)state.func_177229_b(SHAPE));
            if (shape == SoulLilyShape.SMALL && world.func_175623_d(pos.func_177984_a())) {
                STRUCTURE.growMedium((IWorld)world, pos);
            } else if (shape == SoulLilyShape.MEDIUM_BOTTOM && world.func_175623_d(pos.func_177981_b(2)) && this.isAirSides((World)world, pos.func_177981_b(2))) {
                STRUCTURE.growBig((IWorld)world, pos);
            }
        }
    }

    private boolean isAirSides(World world, BlockPos pos) {
        return world.func_175623_d(pos.func_177978_c()) && world.func_175623_d(pos.func_177968_d()) && world.func_175623_d(pos.func_177974_f()) && world.func_175623_d(pos.func_177976_e());
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        SoulLilyShape shape = (SoulLilyShape)((Object)state.func_177229_b(SHAPE));
        int index = this.getRotationIndex(shape);
        if (index < 0) {
            return state;
        }
        int offset = this.rotOffset(rotation);
        return (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)ROT[index + offset & 3]));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        SoulLilyShape shape = (SoulLilyShape)((Object)state.func_177229_b(SHAPE));
        int index = this.getRotationIndex(shape);
        if (index < 0) {
            return state;
        }
        if (mirror == Mirror.FRONT_BACK) {
            if (shape == SoulLilyShape.BIG_TOP_SIDE_E) {
                shape = SoulLilyShape.BIG_TOP_SIDE_W;
            } else if (shape == SoulLilyShape.BIG_TOP_SIDE_W) {
                shape = SoulLilyShape.BIG_TOP_SIDE_E;
            }
        } else if (mirror == Mirror.LEFT_RIGHT) {
            if (shape == SoulLilyShape.BIG_TOP_SIDE_N) {
                shape = SoulLilyShape.BIG_TOP_SIDE_S;
            } else if (shape == SoulLilyShape.BIG_TOP_SIDE_S) {
                shape = SoulLilyShape.BIG_TOP_SIDE_N;
            }
        }
        return (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)shape));
    }

    private int getRotationIndex(SoulLilyShape shape) {
        for (int i = 0; i < 4; ++i) {
            if (shape != ROT[i]) continue;
            return i;
        }
        return -1;
    }

    private int rotOffset(Rotation rotation) {
        if (rotation == Rotation.NONE) {
            return 0;
        }
        if (rotation == Rotation.CLOCKWISE_90) {
            return 1;
        }
        if (rotation == Rotation.CLOCKWISE_180) {
            return 2;
        }
        return 3;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)BlocksRegistry.SOUL_LILY_SAPLING);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        SoulLilyShape shape = (SoulLilyShape)((Object)state.func_177229_b(SHAPE));
        if (shape == SoulLilyShape.BIG_TOP_SIDE_N) {
            return world.func_180495_p(pos.func_177978_c()).func_177230_c() == this;
        }
        if (shape == SoulLilyShape.BIG_TOP_SIDE_S) {
            return world.func_180495_p(pos.func_177968_d()).func_177230_c() == this;
        }
        if (shape == SoulLilyShape.BIG_TOP_SIDE_E) {
            return world.func_180495_p(pos.func_177974_f()).func_177230_c() == this;
        }
        if (shape == SoulLilyShape.BIG_TOP_SIDE_W) {
            return world.func_180495_p(pos.func_177976_e()).func_177230_c() == this;
        }
        BlockState down = world.func_180495_p(pos.func_177977_b());
        return down.func_177230_c() == this || BlocksHelper.isSoulSand(down);
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState neighborState, IWorld world, BlockPos pos, BlockPos neighborPos) {
        return this.func_196260_a(state, (IWorldReader)world, pos) ? state : Blocks.field_150350_a.func_176223_P();
    }

    @Override
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        switch ((SoulLilyShape)((Object)state.func_177229_b(SHAPE))) {
            case BIG_BOTTOM: 
            case BIG_MIDDLE: {
                return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((IItemProvider)BlocksRegistry.MUSHROOM_STEM)});
            }
            case BIG_TOP_CENTER: {
                return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((IItemProvider)BlocksRegistry.MUSHROOM_STEM), new ItemStack((IItemProvider)BlocksRegistry.SOUL_LILY_SAPLING)});
            }
            case MEDIUM_BOTTOM: {
                return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((IItemProvider)BlocksRegistry.MUSHROOM_STEM)});
            }
            case BIG_TOP_SIDE_N: 
            case BIG_TOP_SIDE_S: 
            case BIG_TOP_SIDE_E: 
            case BIG_TOP_SIDE_W: {
                return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((IItemProvider)BlocksRegistry.MUSHROOM_STEM), new ItemStack((IItemProvider)BlocksRegistry.SOUL_LILY_SAPLING, MHelper.randRange(0, 1, MHelper.RANDOM))});
            }
        }
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((IItemProvider)BlocksRegistry.MUSHROOM_STEM), new ItemStack((IItemProvider)BlocksRegistry.SOUL_LILY_SAPLING)});
    }

    public static enum SoulLilyShape implements IStringSerializable
    {
        SMALL("small"),
        MEDIUM_BOTTOM("medium_bottom"),
        MEDIUM_TOP("medium_top"),
        BIG_BOTTOM("big_bottom"),
        BIG_MIDDLE("big_middle"),
        BIG_TOP_CENTER("big_top_center"),
        BIG_TOP_SIDE_N("big_top_side_n"),
        BIG_TOP_SIDE_S("big_top_side_s"),
        BIG_TOP_SIDE_E("big_top_side_e"),
        BIG_TOP_SIDE_W("big_top_side_w");

        final String name;

        private SoulLilyShape(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

