/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.blocks.BlockBaseNotFull;
import someoneelse.betternetherreforged.blocks.materials.MaterialBuilder;
import someoneelse.betternetherreforged.blocks.shapes.TripleShape;

public class BlockSmoker
extends BlockBaseNotFull {
    private static final VoxelShape TOP_SHAPE = BlockSmoker.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    private static final VoxelShape MIDDLE_SHAPE = BlockSmoker.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final EnumProperty<TripleShape> SHAPE = EnumProperty.func_177709_a((String)"shape", TripleShape.class);

    public BlockSmoker() {
        super(MaterialBuilder.makeWood(MaterialColor.field_151650_B));
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(SHAPE, (Comparable)((Object)TripleShape.TOP)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> stateManager) {
        stateManager.func_206894_a(new Property[]{SHAPE});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        if (world.func_175623_d(pos.func_177984_a())) {
            world.func_195594_a((IParticleData)ParticleTypes.field_197594_E, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader view, BlockPos pos, ISelectionContext ePos) {
        return state.func_177229_b(SHAPE) == TripleShape.TOP ? TOP_SHAPE : MIDDLE_SHAPE;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState neighborState, IWorld world, BlockPos pos, BlockPos neighborPos) {
        if (!this.func_196260_a(state, (IWorldReader)world, pos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        Block side = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        if (side != this) {
            return (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)TripleShape.TOP));
        }
        side = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (side == this) {
            return (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)TripleShape.MIDDLE));
        }
        return (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)TripleShape.BOTTOM));
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        BlockState down = world.func_180495_p(pos.func_177977_b());
        return down.func_177230_c() == this || BlocksHelper.isNetherGround(down);
    }
}

