/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.biomes;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.ParticleEffectAmbience;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.MHelper;
import someoneelse.betternetherreforged.biomes.BiomeDefinition;
import someoneelse.betternetherreforged.biomes.NetherBiome;
import someoneelse.betternetherreforged.blocks.BlockSoulSandstone;
import someoneelse.betternetherreforged.noise.OpenSimplexNoise;
import someoneelse.betternetherreforged.registry.BlocksRegistry;
import someoneelse.betternetherreforged.structures.StructureType;
import someoneelse.betternetherreforged.structures.plants.StructureBlackBush;
import someoneelse.betternetherreforged.structures.plants.StructureSoulGrass;
import someoneelse.betternetherreforged.structures.plants.StructureSoulVein;

public class NetherSoulPlain
extends NetherBiome {
    private static final OpenSimplexNoise TERRAIN = new OpenSimplexNoise(245L);
    private static final BlockPos.Mutable POS = new BlockPos.Mutable();

    public NetherSoulPlain(String name) {
        super(new BiomeDefinition(name).setFogColor(196, 113, 239).setLoop(SoundEvents.field_232711_f_).setAdditions(SoundEvents.field_232701_e_).setMood(SoundEvents.field_232722_g_).setParticleConfig(new ParticleEffectAmbience((IParticleData)ParticleTypes.field_197599_J, 0.02f)));
        this.addStructure("soul_vein", new StructureSoulVein(), StructureType.FLOOR, 0.5f, true);
        this.addStructure("black_bush", new StructureBlackBush(), StructureType.FLOOR, 0.02f, false);
        this.addStructure("soul_grass", new StructureSoulGrass(), StructureType.FLOOR, 0.3f, false);
    }

    @Override
    public void genSurfColumn(IWorld world, BlockPos pos, Random random) {
        POS.func_189533_g((Vector3i)pos);
        int d1 = MHelper.randRange(2, 4, random);
        for (int i = 0; i < d1; ++i) {
            POS.func_185336_p(pos.func_177956_o() - i);
            if (BlocksHelper.isNetherGround(world.func_180495_p((BlockPos)POS))) {
                if (TERRAIN.eval((double)pos.func_177958_n() * 0.1, (double)pos.func_177956_o() * 0.1, (double)pos.func_177952_p() * 0.1) > 0.0) {
                    BlocksHelper.setWithoutUpdate(world, (BlockPos)POS, Blocks.field_235336_cN_.func_176223_P());
                    continue;
                }
                BlocksHelper.setWithoutUpdate(world, (BlockPos)POS, Blocks.field_150425_aM.func_176223_P());
                continue;
            }
            return;
        }
        int d2 = MHelper.randRange(5, 7, random);
        for (int i = d1; i < d2; ++i) {
            POS.func_185336_p(pos.func_177956_o() - i);
            if (!BlocksHelper.isNetherGround(world.func_180495_p((BlockPos)POS))) {
                return;
            }
            BlocksHelper.setWithoutUpdate(world, (BlockPos)POS, (BlockState)BlocksRegistry.SOUL_SANDSTONE.func_176223_P().func_206870_a((Property)BlockSoulSandstone.UP, (Comparable)Boolean.valueOf(i == d1)));
        }
    }
}

