/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.biomes;

import java.util.Random;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.biomes.BiomeDefinition;
import someoneelse.betternetherreforged.biomes.NetherBiome;
import someoneelse.betternetherreforged.registry.BlocksRegistry;
import someoneelse.betternetherreforged.registry.EntityRegistry;
import someoneelse.betternetherreforged.registry.SoundsRegistry;
import someoneelse.betternetherreforged.structures.StructureType;
import someoneelse.betternetherreforged.structures.plants.StructureBlackVine;
import someoneelse.betternetherreforged.structures.plants.StructureBloomingVine;
import someoneelse.betternetherreforged.structures.plants.StructureEggPlant;
import someoneelse.betternetherreforged.structures.plants.StructureEye;
import someoneelse.betternetherreforged.structures.plants.StructureFeatherFern;
import someoneelse.betternetherreforged.structures.plants.StructureGoldenVine;
import someoneelse.betternetherreforged.structures.plants.StructureJellyfishMushroom;
import someoneelse.betternetherreforged.structures.plants.StructureJungleMoss;
import someoneelse.betternetherreforged.structures.plants.StructureJunglePlant;
import someoneelse.betternetherreforged.structures.plants.StructureLucis;
import someoneelse.betternetherreforged.structures.plants.StructureMagmaFlower;
import someoneelse.betternetherreforged.structures.plants.StructureReeds;
import someoneelse.betternetherreforged.structures.plants.StructureRubeus;
import someoneelse.betternetherreforged.structures.plants.StructureRubeusBush;
import someoneelse.betternetherreforged.structures.plants.StructureStalagnate;
import someoneelse.betternetherreforged.structures.plants.StructureWallBrownMushroom;
import someoneelse.betternetherreforged.structures.plants.StructureWallMoss;
import someoneelse.betternetherreforged.structures.plants.StructureWallRedMushroom;

public class NetherJungle
extends NetherBiome {
    public NetherJungle(String name) {
        super(new BiomeDefinition(name).setFogColor(62, 169, 61).setLoop(SoundsRegistry.AMBIENT_NETHER_JUNGLE).setAdditions(SoundEvents.field_232701_e_).setMood(SoundEvents.field_232722_g_).setDefaultMobs(false).addMobSpawn(EntityRegistry.JUNGLE_SKELETON, 40, 2, 4));
        this.addStructure("nether_reed", new StructureReeds(), StructureType.FLOOR, 0.5f, false);
        this.addStructure("stalagnate", new StructureStalagnate(), StructureType.FLOOR, 0.2f, false);
        this.addStructure("rubeus_tree", new StructureRubeus(), StructureType.FLOOR, 0.1f, false);
        this.addStructure("bush_rubeus", new StructureRubeusBush(), StructureType.FLOOR, 0.1f, false);
        this.addStructure("magma_flower", new StructureMagmaFlower(), StructureType.FLOOR, 0.5f, false);
        this.addStructure("egg_plant", new StructureEggPlant(), StructureType.FLOOR, 0.05f, true);
        this.addStructure("jellyfish_mushroom", new StructureJellyfishMushroom(), StructureType.FLOOR, 0.03f, true);
        this.addStructure("feather_fern", new StructureFeatherFern(), StructureType.FLOOR, 0.05f, true);
        this.addStructure("jungle_plant", new StructureJunglePlant(), StructureType.FLOOR, 0.1f, false);
        this.addStructure("lucis", new StructureLucis(), StructureType.WALL, 0.1f, false);
        this.addStructure("eye", new StructureEye(), StructureType.CEIL, 0.1f, true);
        this.addStructure("black_vine", new StructureBlackVine(), StructureType.CEIL, 0.1f, true);
        this.addStructure("golden_vine", new StructureGoldenVine(), StructureType.CEIL, 0.1f, true);
        this.addStructure("flowered_vine", new StructureBloomingVine(), StructureType.CEIL, 0.1f, true);
        this.addStructure("jungle_moss", new StructureJungleMoss(), StructureType.WALL, 0.8f, true);
        this.addStructure("wall_moss", new StructureWallMoss(), StructureType.WALL, 0.2f, true);
        this.addStructure("wall_red_mushroom", new StructureWallRedMushroom(), StructureType.WALL, 0.8f, true);
        this.addStructure("wall_brown_mushroom", new StructureWallBrownMushroom(), StructureType.WALL, 0.8f, true);
        this.addWorldStructures(NetherJungle.structureFormat("ruined_temple", -4, StructureType.FLOOR, 10.0f));
        this.addWorldStructures(NetherJungle.structureFormat("jungle_temple_altar", -2, StructureType.FLOOR, 10.0f));
        this.addWorldStructures(NetherJungle.structureFormat("jungle_temple_2", -2, StructureType.FLOOR, 10.0f));
        this.addWorldStructures(NetherJungle.structureFormat("jungle_bones_1", 0, StructureType.FLOOR, 20.0f));
        this.addWorldStructures(NetherJungle.structureFormat("jungle_bones_2", 0, StructureType.FLOOR, 20.0f));
        this.addWorldStructures(NetherJungle.structureFormat("jungle_bones_3", 0, StructureType.FLOOR, 20.0f));
        this.setNoiseDensity(0.5f);
    }

    @Override
    public void genSurfColumn(IWorld world, BlockPos pos, Random random) {
        BlocksHelper.setWithoutUpdate(world, pos, BlocksRegistry.JUNGLE_GRASS.func_176223_P());
    }
}

