/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.biomes;

import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.ParticleEffectAmbience;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.biomes.BiomeDefinition;
import someoneelse.betternetherreforged.biomes.NetherBiome;
import someoneelse.betternetherreforged.registry.SoundsRegistry;
import someoneelse.betternetherreforged.structures.StructureType;
import someoneelse.betternetherreforged.structures.plants.StructureAgave;
import someoneelse.betternetherreforged.structures.plants.StructureBarrelCactus;
import someoneelse.betternetherreforged.structures.plants.StructureNetherCactus;

public class NetherGravelDesert
extends NetherBiome {
    public NetherGravelDesert(String name) {
        super(new BiomeDefinition(name).setFogColor(170, 48, 0).setLoop(SoundsRegistry.AMBIENT_GRAVEL_DESERT).setMood(SoundEvents.field_232769_j_).setAdditions(SoundEvents.field_232723_h_).setMusic(SoundEvents.field_232760_ip_).setParticleConfig(new ParticleEffectAmbience((IParticleData)ParticleTypes.field_239813_am_, 0.02f)));
        this.addStructure("nether_cactus", new StructureNetherCactus(), StructureType.FLOOR, 0.02f, true);
        this.addStructure("agave", new StructureAgave(), StructureType.FLOOR, 0.02f, true);
        this.addStructure("barrel_cactus", new StructureBarrelCactus(), StructureType.FLOOR, 0.02f, true);
    }

    @Override
    public void genSurfColumn(IWorld world, BlockPos pos, Random random) {
        for (int i = 0; i < 1 + random.nextInt(3); ++i) {
            BlockPos p2 = pos.func_177979_c(i);
            if (!BlocksHelper.isNetherGround(world.func_180495_p(p2))) continue;
            if (world.func_175623_d(p2.func_177977_b())) {
                BlocksHelper.setWithoutUpdate(world, p2, Blocks.field_150424_aL.func_176223_P());
                return;
            }
            BlocksHelper.setWithoutUpdate(world, p2, Blocks.field_150351_n.func_176223_P());
        }
    }
}

