/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.utils;

import com.infamous.dungeons_mobs.entities.jungle.VineEntity;
import com.infamous.dungeons_mobs.entities.summonables.ConstructEntity;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;

public class GeomancyHelper {
    private static final int[] NORTH_ROW = new int[]{2, 3, 4, 5, 6};
    private static final int[] EAST_ROW = new int[]{6, 7, 8, 9, 10};
    private static final int[] SOUTH_ROW = new int[]{10, 11, 12, 13, 14};
    private static final int[] WEST_ROW = new int[]{14, 15, 0, 1, 2};
    public static final int[][] ROWS = new int[][]{NORTH_ROW, EAST_ROW, SOUTH_ROW, WEST_ROW};
    private static final Direction[] DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    private static boolean isValueInArray(int[] arr, int toCheckValue) {
        for (int element : arr) {
            if (element != toCheckValue) continue;
            return true;
        }
        return false;
    }

    private static double getZShift(int i, double zshift) {
        if (i >= 10 && i <= 14) {
            zshift = -2.0;
        }
        if (i >= 2 && i <= 6) {
            zshift = 2.0;
        }
        if (i == 9 || i == 15) {
            zshift = -1.0;
        }
        if (i == 1 || i == 7) {
            zshift = 1.0;
        }
        return zshift;
    }

    private static double getXShift(int i, double xshift) {
        if (i == 0 || i == 1 || i == 2 || i == 14 || i == 15) {
            xshift = -2.0;
        }
        if (i >= 6 && i <= 10) {
            xshift = 2.0;
        }
        if (i == 3 || i == 13) {
            xshift = -1.0;
        }
        if (i == 5 || i == 11) {
            xshift = 1.0;
        }
        return xshift;
    }

    private static BlockPos createCenteredBlockPosOnTarget(Entity targetEntity) {
        return new BlockPos(Math.floor(targetEntity.func_226277_ct_()), Math.floor(targetEntity.func_226278_cu_()), Math.floor(targetEntity.func_226281_cx_()));
    }

    private static void summonAreaDenialConstruct(LivingEntity casterEntity, Entity targetEntity, EntityType<? extends ConstructEntity> wallEntityType, double xshift, double zshift, Direction pillarFacing) {
        ConstructEntity constructEntity;
        BlockPos targetPos = GeomancyHelper.createCenteredBlockPosOnTarget(targetEntity).func_177963_a(xshift, 0.0, zshift);
        if (GeomancyHelper.canAllowBlockEntitySpawn((Entity)casterEntity, targetPos) && (constructEntity = (ConstructEntity)wallEntityType.func_200721_a(casterEntity.field_70170_p)) != null) {
            constructEntity.setCaster(casterEntity);
            constructEntity.func_70107_b(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p());
            constructEntity.setLifeTicks(100);
            constructEntity.faceDirection(pillarFacing);
            casterEntity.field_70170_p.func_217376_c((Entity)constructEntity);
        }
    }

    private static void summonAreaDenialConstruct(LivingEntity casterEntity, BlockPos targetPos, EntityType<? extends ConstructEntity> wallEntityType, double xshift, double zshift, Direction pillarFacing) {
        ConstructEntity constructEntity;
        if (GeomancyHelper.canAllowBlockEntitySpawn((Entity)casterEntity, targetPos = targetPos.func_177963_a(xshift, 0.0, zshift)) && (constructEntity = (ConstructEntity)wallEntityType.func_200721_a(casterEntity.field_70170_p)) != null) {
            constructEntity.setCaster(casterEntity);
            constructEntity.func_70107_b(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p());
            constructEntity.setLifeTicks(100);
            constructEntity.faceDirection(pillarFacing);
            casterEntity.field_70170_p.func_217376_c((Entity)constructEntity);
        }
    }

    public static void summonOffensiveVine(LivingEntity casterEntity, LivingEntity targetEntity, EntityType<? extends VineEntity> entityType) {
        VineEntity vineEntity;
        BlockPos targetPos = GeomancyHelper.createCenteredBlockPosOnTarget((Entity)targetEntity);
        if (GeomancyHelper.canAllowBlockEntitySpawn((Entity)casterEntity, targetPos) && (vineEntity = (VineEntity)entityType.func_200721_a(casterEntity.field_70170_p)) != null) {
            vineEntity.setCaster(casterEntity);
            vineEntity.func_70107_b(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p());
            casterEntity.field_70170_p.func_217376_c((Entity)vineEntity);
        }
    }

    private static void summonAreaDenialVine(LivingEntity casterEntity, LivingEntity targetEntity, EntityType<? extends VineEntity> entityType, double xshift, double zshift, Direction pillarFacing) {
        VineEntity vineEntity;
        BlockPos targetPos = GeomancyHelper.createCenteredBlockPosOnTarget((Entity)targetEntity).func_177963_a(xshift, 0.0, zshift);
        if (GeomancyHelper.canAllowBlockEntitySpawn((Entity)casterEntity, targetPos) && (vineEntity = (VineEntity)entityType.func_200721_a(casterEntity.field_70170_p)) != null) {
            vineEntity.setCaster(casterEntity);
            vineEntity.setLifeTicks(100);
            vineEntity.func_70107_b(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p());
            casterEntity.field_70170_p.func_217376_c((Entity)vineEntity);
        }
    }

    public static void summonOffensiveConstruct(LivingEntity casterEntity, Entity targetEntity, EntityType<? extends ConstructEntity> entityType) {
        ConstructEntity constructEntity;
        BlockPos targetPos = GeomancyHelper.createCenteredBlockPosOnTarget(targetEntity);
        if (GeomancyHelper.canAllowBlockEntitySpawn((Entity)casterEntity, targetPos) && (constructEntity = (ConstructEntity)entityType.func_200721_a(casterEntity.field_70170_p)) != null) {
            constructEntity.setCaster(casterEntity);
            constructEntity.func_70107_b(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p());
            constructEntity.setLifeTicks(100);
            casterEntity.field_70170_p.func_217376_c((Entity)constructEntity);
        }
    }

    public static void summonOffensiveConstruct(LivingEntity casterEntity, BlockPos targetPos, EntityType<? extends ConstructEntity> entityType) {
        ConstructEntity constructEntity;
        if (GeomancyHelper.canAllowBlockEntitySpawn((Entity)casterEntity, targetPos) && (constructEntity = (ConstructEntity)entityType.func_200721_a(casterEntity.field_70170_p)) != null) {
            constructEntity.setCaster(casterEntity);
            constructEntity.func_70107_b(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p());
            constructEntity.setLifeTicks(100);
            casterEntity.field_70170_p.func_217376_c((Entity)constructEntity);
        }
    }

    public static void summonAreaDenialTrap(LivingEntity casterEntity, Entity targetEntity, EntityType<? extends ConstructEntity> entityType, int[] rowToRemove) {
        for (int constructPositionIndex = 0; constructPositionIndex <= 15; ++constructPositionIndex) {
            if (GeomancyHelper.isValueInArray(rowToRemove, constructPositionIndex)) continue;
            double xshift = 0.0;
            double zshift = 0.0;
            xshift = GeomancyHelper.getXShift(constructPositionIndex, xshift);
            zshift = GeomancyHelper.getZShift(constructPositionIndex, zshift);
            Direction pillarFacing = (Direction)Util.func_240989_a_((Object[])DIRECTIONS, (Random)casterEntity.func_70681_au());
            GeomancyHelper.summonAreaDenialConstruct(casterEntity, targetEntity, entityType, xshift, zshift, pillarFacing);
        }
    }

    public static void summonAreaDenialTrap(LivingEntity casterEntity, BlockPos targetPos, EntityType<? extends ConstructEntity> entityType, int[] rowToRemove) {
        for (int constructPositionIndex = 0; constructPositionIndex <= 15; ++constructPositionIndex) {
            if (GeomancyHelper.isValueInArray(rowToRemove, constructPositionIndex)) continue;
            double xshift = 0.0;
            double zshift = 0.0;
            xshift = GeomancyHelper.getXShift(constructPositionIndex, xshift);
            zshift = GeomancyHelper.getZShift(constructPositionIndex, zshift);
            Direction pillarFacing = (Direction)Util.func_240989_a_((Object[])DIRECTIONS, (Random)casterEntity.func_70681_au());
            GeomancyHelper.summonAreaDenialConstruct(casterEntity, targetPos, entityType, xshift, zshift, pillarFacing);
        }
    }

    public static void summonAreaDenialVineTrap(LivingEntity casterEntity, LivingEntity targetEntity, EntityType<? extends VineEntity> entityType, int[] rowToRemove) {
        for (int constructPositionIndex = 0; constructPositionIndex <= 15; ++constructPositionIndex) {
            if (GeomancyHelper.isValueInArray(rowToRemove, constructPositionIndex)) continue;
            double xshift = 0.0;
            double zshift = 0.0;
            xshift = GeomancyHelper.getXShift(constructPositionIndex, xshift);
            zshift = GeomancyHelper.getZShift(constructPositionIndex, zshift);
            Direction pillarFacing = (Direction)Util.func_240989_a_((Object[])DIRECTIONS, (Random)casterEntity.func_70681_au());
            GeomancyHelper.summonAreaDenialVine(casterEntity, targetEntity, entityType, xshift, zshift, pillarFacing);
        }
    }

    public static boolean canAllowBlockEntitySpawn(Entity entity, BlockPos blockPos) {
        return (entity.field_70170_p.func_175623_d(blockPos) || entity.field_70170_p.func_180495_p(blockPos).func_227032_a_(Fluids.field_204541_a)) && !entity.field_70170_p.func_175623_d(blockPos.func_177977_b());
    }
}

