/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.tasks;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.item.Item;
import net.minecraft.util.math.EntityPosWrapper;
import net.minecraft.world.server.ServerWorld;

public class ThrowAtTargetTask<E extends MobEntity>
extends Task<E> {
    private int attackDelay = 0;
    private final Predicate<Item> throwItemPredicate;
    private final BiConsumer<E, LivingEntity> performRangedAttack;

    public ThrowAtTargetTask(Predicate<Item> throwItemPredicate, BiConsumer<E, LivingEntity> performRangedAttack) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleStatus.REGISTERED, (Object)MemoryModuleType.field_234103_o_, (Object)MemoryModuleStatus.VALUE_PRESENT), 1200);
        this.throwItemPredicate = throwItemPredicate;
        this.performRangedAttack = performRangedAttack;
    }

    protected boolean checkExtraStartConditions(ServerWorld serverWorld, E thrower) {
        LivingEntity attackTarget = ThrowAtTargetTask.getAttackTarget(thrower);
        return thrower.func_233634_a_(this.throwItemPredicate) && BrainUtil.func_233876_c_(thrower, (LivingEntity)attackTarget) && BrainUtil.func_233869_a_(thrower, (LivingEntity)attackTarget, (int)0);
    }

    protected boolean canStillUse(ServerWorld serverWorld, E thrower, long gameTime) {
        return thrower.func_213375_cj().func_218191_a(MemoryModuleType.field_234103_o_) && this.checkExtraStartConditions(serverWorld, thrower);
    }

    protected void tick(ServerWorld serverWorld, E thrower, long gameTime) {
        LivingEntity attackTarget = ThrowAtTargetTask.getAttackTarget(thrower);
        this.lookAtTarget((MobEntity)thrower, attackTarget);
        this.throwAttack(thrower, attackTarget);
    }

    private void throwAttack(E thrower, LivingEntity attackTarget) {
        if (this.attackDelay > 0) {
            --this.attackDelay;
        }
        if (this.attackDelay <= 0) {
            this.performRangedAttack.accept(thrower, attackTarget);
            this.attackDelay = 50 + thrower.func_70681_au().nextInt(20);
        }
    }

    private void lookAtTarget(MobEntity attacker, LivingEntity attackTarget) {
        attacker.func_213375_cj().func_218205_a(MemoryModuleType.field_220951_l, (Object)new EntityPosWrapper((Entity)attackTarget, true));
    }

    private static LivingEntity getAttackTarget(LivingEntity attacker) {
        return (LivingEntity)attacker.func_213375_cj().func_218207_c(MemoryModuleType.field_234103_o_).get();
    }
}

