/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.interfaces;

import java.util.Random;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.nbt.CompoundNBT;

public interface IArmoredMob {
    public static final Random RANDOM = new Random();
    public static final float STRONG_ARMOR_SPAWN_CHANCE = 0.25f;

    default public void writeStrongArmorNBT(CompoundNBT compound) {
        if (this.hasStrongArmor()) {
            compound.func_74757_a("StrongArmor", true);
        }
    }

    default public void readStrongArmorNBT(CompoundNBT compound) {
        if (compound.func_150297_b("StrongArmor", 99)) {
            this.setStrongArmor(compound.func_74767_n("StrongArmor"));
        }
    }

    public boolean hasStrongArmor();

    public void setStrongArmor(boolean var1);

    default public <T extends LivingEntity> void designateStrongArmor(T armoredMob) {
        if (this != armoredMob) {
            throw new IllegalArgumentException("Supplied armored mob does not match this instance!");
        }
        float strongArmorChance = RANDOM.nextFloat();
        if (strongArmorChance < 0.25f) {
            this.setStrongArmored((MobEntity)armoredMob);
        }
    }

    default public void setStrongArmored(MobEntity armoredMob) {
        if (this != armoredMob) {
            throw new IllegalArgumentException("Supplied armored mob does not match this instance!");
        }
        this.setStrongArmor(true);
        this.applyStrongArmorBoosts(armoredMob);
    }

    default public void applyStrongArmorBoosts(MobEntity armoredMob) {
        if (this != armoredMob) {
            throw new IllegalArgumentException("Supplied armored mob does not match this instance!");
        }
        armoredMob.func_110148_a(Attributes.field_233826_i_).func_233769_c_(new AttributeModifier("Strong armor boost", 10.0, AttributeModifier.Operation.ADDITION));
        armoredMob.func_110148_a(Attributes.field_233820_c_).func_233769_c_(new AttributeModifier("Strong knockback resistance boost", 0.6, AttributeModifier.Operation.ADDITION));
        armoredMob.func_110148_a(Attributes.field_233823_f_).func_233769_c_(new AttributeModifier("Strong attack boost", 1.0, AttributeModifier.Operation.ADDITION));
    }

    public String getArmorName();
}

