/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.goals;

import java.util.EnumSet;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.Item;
import net.minecraft.util.math.MathHelper;

public class SimpleRangedAttackGoal<T extends MobEntity>
extends Goal {
    private final T mob;
    private final BiConsumer<T, LivingEntity> performRangedAttack;
    private final Predicate<Item> weaponPredicate;
    private LivingEntity target;
    private int attackTime = -1;
    private final double speedModifier;
    private int seeTime;
    private final int attackIntervalMin;
    private final int attackIntervalMax;
    private final float attackRadius;
    private final float attackRadiusSqr;

    public SimpleRangedAttackGoal(T p_i1649_1_, Predicate<Item> weaponPredicate, BiConsumer<T, LivingEntity> performRangedAttack, double p_i1649_2_, int p_i1649_4_, float p_i1649_5_) {
        this(p_i1649_1_, weaponPredicate, performRangedAttack, p_i1649_2_, p_i1649_4_, p_i1649_4_, p_i1649_5_);
    }

    public SimpleRangedAttackGoal(T p_i1650_1_, Predicate<Item> weaponPredicate, BiConsumer<T, LivingEntity> performRangedAttack, double p_i1650_2_, int p_i1650_4_, int p_i1650_5_, float p_i1650_6_) {
        this.mob = p_i1650_1_;
        this.weaponPredicate = weaponPredicate;
        this.performRangedAttack = performRangedAttack;
        this.speedModifier = p_i1650_2_;
        this.attackIntervalMin = p_i1650_4_;
        this.attackIntervalMax = p_i1650_5_;
        this.attackRadius = p_i1650_6_;
        this.attackRadiusSqr = p_i1650_6_ * p_i1650_6_;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        if (!this.mob.func_233634_a_(this.weaponPredicate)) {
            return false;
        }
        LivingEntity livingentity = this.mob.func_70638_az();
        if (livingentity != null && livingentity.func_70089_S()) {
            this.target = livingentity;
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        if (!this.mob.func_233634_a_(this.weaponPredicate)) {
            return false;
        }
        return this.func_75250_a() || !this.mob.func_70661_as().func_75500_f();
    }

    public void func_75251_c() {
        this.target = null;
        this.seeTime = 0;
        this.attackTime = -1;
    }

    public void func_75246_d() {
        double d0 = this.mob.func_70092_e(this.target.func_226277_ct_(), this.target.func_226278_cu_(), this.target.func_226281_cx_());
        boolean flag = this.mob.func_70635_at().func_75522_a((Entity)this.target);
        this.seeTime = flag ? ++this.seeTime : 0;
        if (!(d0 > (double)this.attackRadiusSqr) && this.seeTime >= 5) {
            this.mob.func_70661_as().func_75499_g();
        } else {
            this.mob.func_70661_as().func_75497_a((Entity)this.target, this.speedModifier);
        }
        this.mob.func_70671_ap().func_75651_a((Entity)this.target, 30.0f, 30.0f);
        if (--this.attackTime == 0) {
            if (!flag) {
                return;
            }
            float f = MathHelper.func_76133_a((double)d0) / this.attackRadius;
            float lvt_5_1_ = MathHelper.func_76131_a((float)f, (float)0.1f, (float)1.0f);
            this.performRangedAttack.accept(this.mob, this.target);
            this.attackTime = MathHelper.func_76141_d((float)(f * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin));
        } else if (this.attackTime < 0) {
            float f2 = MathHelper.func_76133_a((double)d0) / this.attackRadius;
            this.attackTime = MathHelper.func_76141_d((float)(f2 * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin));
        }
    }
}

