/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.water;

import com.infamous.dungeons_mobs.entities.jungle.PoisonQuillVineEntity;
import com.infamous.dungeons_mobs.entities.jungle.QuickGrowingVineEntity;
import com.infamous.dungeons_mobs.entities.jungle.WhispererEntity;
import com.infamous.dungeons_mobs.goals.AquaticMoveHelperController;
import com.infamous.dungeons_mobs.goals.GoToBeachGoal;
import com.infamous.dungeons_mobs.goals.GoToWaterGoal;
import com.infamous.dungeons_mobs.goals.SwimUpGoal;
import com.infamous.dungeons_mobs.interfaces.IAquaticMob;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biomes;

public class WavewhispererEntity
extends WhispererEntity
implements IAquaticMob {
    private boolean searchingForLand;
    protected final SwimmerPathNavigator waterNavigation;
    protected final GroundPathNavigator groundNavigation;

    public WavewhispererEntity(EntityType<? extends WavewhispererEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
        this.field_70765_h = new AquaticMoveHelperController<WavewhispererEntity>(this);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.waterNavigation = new SwimmerPathNavigator((MobEntity)this, worldIn);
        this.groundNavigation = new GroundPathNavigator((MobEntity)this, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return WhispererEntity.setCustomAttributes();
    }

    @Override
    protected void addMovementBehaviors() {
        this.field_70714_bg.func_75776_a(1, (Goal)new GoToWaterGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, new GoToBeachGoal<WavewhispererEntity>(this, 1.0));
        this.field_70714_bg.func_75776_a(6, new SwimUpGoal<WavewhispererEntity>(this, 1.0, this.field_70170_p.func_181545_F()));
        this.field_70714_bg.func_75776_a(7, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
    }

    @Override
    protected EntityType<? extends PoisonQuillVineEntity> getPoisonVineType() {
        return (EntityType)ModEntityTypes.POISON_ANEMONE.get();
    }

    @Override
    protected EntityType<? extends QuickGrowingVineEntity> getQuickGrowingVineType() {
        return (EntityType)ModEntityTypes.QUICK_GROWING_ANEMONE.get();
    }

    public boolean func_70648_aU() {
        return true;
    }

    public static boolean checkWavewhispererSpawnRules(EntityType<? extends WavewhispererEntity> p_223332_0_, IServerWorld serverWorld, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        boolean canSpawn;
        Optional biomeName = serverWorld.func_242406_i(blockPos);
        boolean bl = canSpawn = serverWorld.func_175659_aa() != Difficulty.PEACEFUL && WavewhispererEntity.func_223323_a((IServerWorld)serverWorld, (BlockPos)blockPos, (Random)random) && (spawnReason == SpawnReason.SPAWNER || serverWorld.func_204610_c(blockPos).func_206884_a((ITag)FluidTags.field_206959_a));
        if (!Objects.equals(biomeName, Optional.of(Biomes.field_76781_i)) && !Objects.equals(biomeName, Optional.of(Biomes.field_76777_m))) {
            return random.nextInt(40) == 0 && IAquaticMob.isDeepEnoughToSpawn((IWorld)serverWorld, blockPos) && canSpawn;
        }
        return random.nextInt(15) == 0 && canSpawn;
    }

    @Override
    public void setSearchingForLand(boolean searchingForLand) {
        this.searchingForLand = searchingForLand;
    }

    public boolean func_205019_a(IWorldReader worldReader) {
        return worldReader.func_226668_i_((Entity)this);
    }

    public boolean func_96092_aw() {
        return !this.func_203007_ba();
    }

    public void func_205343_av() {
        this.updateNavigation((MobEntity)this);
    }

    public void func_213352_e(Vector3d travelVec) {
        this.checkAquaticTravel((MobEntity)this, travelVec);
    }

    @Override
    public void normalTravel(Vector3d travelVec) {
        super.func_213352_e(travelVec);
    }

    @Override
    public boolean isSearchingForLand() {
        return this.searchingForLand;
    }

    @Override
    public void setNavigation(PathNavigator navigation) {
        this.field_70699_by = navigation;
    }

    @Override
    public GroundPathNavigator getGroundNavigation() {
        return this.groundNavigation;
    }

    @Override
    public SwimmerPathNavigator getWaterNavigation() {
        return this.waterNavigation;
    }
}

