/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.water;

import com.infamous.dungeons_mobs.goals.AquaticMoveHelperController;
import com.infamous.dungeons_mobs.goals.GoToBeachGoal;
import com.infamous.dungeons_mobs.goals.GoToWaterGoal;
import com.infamous.dungeons_mobs.goals.SwimUpGoal;
import com.infamous.dungeons_mobs.interfaces.IAquaticMob;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ICrossbowUser;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShootableItem;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biomes;

public class SunkenSkeletonEntity
extends AbstractSkeletonEntity
implements ICrossbowUser,
IAquaticMob {
    private final RangedBowAttackGoal<SunkenSkeletonEntity> bowGoal = new RangedBowAttackGoal((MonsterEntity)this, 1.0, 20, 15.0f);
    private final MeleeAttackGoal meleeGoal = new MeleeAttackGoal((CreatureEntity)this, 1.2, false){

        public boolean func_75250_a() {
            return super.func_75250_a() && SunkenSkeletonEntity.this.okTarget((LivingEntity)SunkenSkeletonEntity.this, SunkenSkeletonEntity.this.func_70638_az());
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && SunkenSkeletonEntity.this.okTarget((LivingEntity)SunkenSkeletonEntity.this, SunkenSkeletonEntity.this.func_70638_az());
        }
    };
    private final RangedCrossbowAttackGoal<SunkenSkeletonEntity> crossbowGoal = new RangedCrossbowAttackGoal((MonsterEntity)this, 1.0, 15.0f);
    private static final DataParameter<Boolean> CHARGING_CROSSBOW = EntityDataManager.func_187226_a(SunkenSkeletonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private boolean searchingForLand;
    protected final SwimmerPathNavigator waterNavigation;
    protected final GroundPathNavigator groundNavigation;
    private final boolean isConstructed;

    public SunkenSkeletonEntity(EntityType<? extends SunkenSkeletonEntity> entityType, World world) {
        super(entityType, world);
        this.isConstructed = true;
        this.field_70138_W = 1.0f;
        this.field_70765_h = new AquaticMoveHelperController<SunkenSkeletonEntity>(this);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.waterNavigation = new SwimmerPathNavigator((MobEntity)this, world);
        this.groundNavigation = new GroundPathNavigator((MobEntity)this, world);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return AbstractSkeletonEntity.func_234275_m_();
    }

    public static boolean checkSunkenSkeletonSpawnRules(EntityType<? extends SunkenSkeletonEntity> p_223332_0_, IServerWorld serverWorld, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        boolean canSpawn;
        Optional biomeName = serverWorld.func_242406_i(blockPos);
        boolean bl = canSpawn = serverWorld.func_175659_aa() != Difficulty.PEACEFUL && SunkenSkeletonEntity.func_223323_a((IServerWorld)serverWorld, (BlockPos)blockPos, (Random)random) && (spawnReason == SpawnReason.SPAWNER || serverWorld.func_204610_c(blockPos).func_206884_a((ITag)FluidTags.field_206959_a));
        if (!Objects.equals(biomeName, Optional.of(Biomes.field_76781_i)) && !Objects.equals(biomeName, Optional.of(Biomes.field_76777_m))) {
            return random.nextInt(40) == 0 && IAquaticMob.isDeepEnoughToSpawn((IWorld)serverWorld, blockPos) && canSpawn;
        }
        return random.nextInt(15) == 0 && canSpawn;
    }

    public boolean func_205019_a(IWorldReader worldReader) {
        return worldReader.func_226668_i_((Entity)this);
    }

    public boolean func_96092_aw() {
        return !this.func_203007_ba();
    }

    public void func_213352_e(Vector3d travelVec) {
        this.checkAquaticTravel((MobEntity)this, travelVec);
    }

    @Override
    public void normalTravel(Vector3d travelVec) {
        super.func_213352_e(travelVec);
    }

    public void func_205343_av() {
        this.updateNavigation((MobEntity)this);
    }

    @Override
    public boolean isSearchingForLand() {
        return this.searchingForLand;
    }

    @Override
    public void setNavigation(PathNavigator navigation) {
        this.field_70699_by = navigation;
    }

    @Override
    public GroundPathNavigator getGroundNavigation() {
        return this.groundNavigation;
    }

    @Override
    public SwimmerPathNavigator getWaterNavigation() {
        return this.waterNavigation;
    }

    @Override
    public void setSearchingForLand(boolean searchingForLand) {
        this.searchingForLand = searchingForLand;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new GoToWaterGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, new GoToBeachGoal<SunkenSkeletonEntity>(this, 1.0));
        this.field_70714_bg.func_75776_a(6, new SwimUpGoal<SunkenSkeletonEntity>(this, 1.0, this.field_70170_p.func_181545_F()));
        this.field_70714_bg.func_75776_a(7, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{SunkenSkeletonEntity.class}).func_220794_a(new Class[]{SunkenSkeletonEntity.class}));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, target -> this.okTarget((LivingEntity)this, (LivingEntity)target)));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, false));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, TurtleEntity.class, 10, true, false, TurtleEntity.field_203029_bx));
    }

    public void func_85036_m() {
        if (this.isConstructed && this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.field_70714_bg.func_85156_a((Goal)this.meleeGoal);
            this.field_70714_bg.func_85156_a(this.bowGoal);
            this.field_70714_bg.func_85156_a(this.crossbowGoal);
            ItemStack bowStack = this.func_184586_b(ProjectileHelper.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem));
            ItemStack crossbowStack = this.func_184586_b(ProjectileHelper.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof CrossbowItem));
            if (bowStack.func_77973_b() instanceof BowItem) {
                int i = 20;
                if (this.field_70170_p.func_175659_aa() != Difficulty.HARD) {
                    i = 40;
                }
                this.bowGoal.func_189428_b(i);
                this.field_70714_bg.func_75776_a(2, this.bowGoal);
            } else if (crossbowStack.func_77973_b() instanceof CrossbowItem) {
                this.field_70714_bg.func_75776_a(2, this.crossbowGoal);
            } else {
                this.field_70714_bg.func_75776_a(2, (Goal)this.meleeGoal);
            }
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CHARGING_CROSSBOW, (Object)false);
    }

    protected void func_180481_a(DifficultyInstance p_180481_1_) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_222114_py));
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187854_fc;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187864_fh;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187856_fd;
    }

    protected SoundEvent func_190727_o() {
        return SoundEvents.field_187868_fj;
    }

    public void func_213671_a(boolean chargingCrossbow) {
        this.field_70180_af.func_187227_b(CHARGING_CROSSBOW, (Object)chargingCrossbow);
    }

    public void func_230284_a_(LivingEntity target, ItemStack crossbow, ProjectileEntity projectile, float inaccuracy) {
        this.func_234279_a_((LivingEntity)this, target, projectile, inaccuracy, 1.6f);
    }

    public void func_230283_U__() {
        this.field_70708_bq = 0;
    }

    public void func_82196_d(LivingEntity target, float p_82196_2_) {
        if (this.func_233634_a_(item -> item instanceof BowItem)) {
            super.func_82196_d(target, p_82196_2_);
        } else {
            this.func_234281_b_((LivingEntity)this, 1.6f);
        }
    }

    public boolean func_230280_a_(ShootableItem shootable) {
        return shootable instanceof BowItem || shootable instanceof CrossbowItem;
    }
}

