/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.undead.horseman;

import com.infamous.dungeons_mobs.entities.undead.ArmoredSkeletonEntity;
import com.infamous.dungeons_mobs.entities.undead.horseman.TriggerHorsemanTrapGoal;
import com.infamous.dungeons_mobs.interfaces.IMountUser;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class SkeletonHorsemanEntity
extends ArmoredSkeletonEntity
implements IMountUser {
    private final TriggerHorsemanTrapGoal horsemanTrapGoal = new TriggerHorsemanTrapGoal(this);
    private boolean isHorsemanTrap;
    private int horsemanTrapTime;

    public SkeletonHorsemanEntity(World worldIn) {
        super((EntityType<? extends ArmoredSkeletonEntity>)((EntityType)ModEntityTypes.SKELETON_HORSEMAN.get()), worldIn);
    }

    public SkeletonHorsemanEntity(EntityType<? extends SkeletonHorsemanEntity> entityType, World world) {
        super(entityType, world);
        this.field_70749_g = new HorsemanLookController((MobEntity)this);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return ArmoredSkeletonEntity.setCustomAttributes();
    }

    @Override
    protected void func_180481_a(DifficultyInstance difficultyInstance) {
        if (ModList.get().isLoaded("dungeons_gear")) {
            Item REINFORCED_MAIL_HELMET = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("dungeons_gear", "reinforced_mail_helmet"));
            Item LONGBOW = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("dungeons_gear", "longbow"));
            ItemStack reinforcedMailHelmet = new ItemStack((IItemProvider)REINFORCED_MAIL_HELMET);
            ItemStack longbow = new ItemStack((IItemProvider)LONGBOW);
            this.func_184201_a(EquipmentSlotType.HEAD, reinforcedMailHelmet);
            this.func_184201_a(EquipmentSlotType.MAINHAND, longbow);
        } else {
            this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Items.field_151028_Y));
            this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151031_f));
        }
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData livingEntityDataIn, @Nullable CompoundNBT compoundNBT) {
        livingEntityDataIn = super.func_213386_a(world, difficultyInstance, spawnReason, livingEntityDataIn, compoundNBT);
        if (spawnReason != SpawnReason.TRIGGERED) {
            this.setTrap(true);
        }
        return livingEntityDataIn;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.isTrap() && this.horsemanTrapTime++ >= 18000) {
            this.func_70106_y();
        }
    }

    public boolean func_184191_r(Entity entityIn) {
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof SkeletonHorsemanEntity) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    private boolean isTrap() {
        return this.isHorsemanTrap;
    }

    void setTrap(boolean trap) {
        if (trap != this.isHorsemanTrap) {
            this.isHorsemanTrap = trap;
            if (trap) {
                this.field_70714_bg.func_75776_a(1, (Goal)this.horsemanTrapGoal);
            } else {
                this.field_70714_bg.func_85156_a((Goal)this.horsemanTrapGoal);
            }
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("HorsemanTrap", this.isTrap());
        compound.func_74768_a("HorsemanTrapTime", this.horsemanTrapTime);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setTrap(compound.func_74767_n("HorsemanTrap"));
        this.horsemanTrapTime = compound.func_74762_e("HorsemanTrapTime");
    }

    @Override
    public void func_82196_d(LivingEntity target, float distanceFactor) {
        super.func_82196_d(target, distanceFactor);
        if (this.func_184187_bx() instanceof AbstractHorseEntity) {
            AbstractHorseEntity horseEntity = (AbstractHorseEntity)this.func_184187_bx();
            horseEntity.func_190687_dF();
        }
    }

    static class HorsemanLookController
    extends LookController {
        HorsemanLookController(MobEntity mob) {
            super(mob);
        }

        public void func_75649_a() {
            super.func_75649_a();
            if (this.field_75659_a.func_184218_aH() && this.field_75659_a.func_70638_az() != null && this.isNotGettingAttackedByAWolf()) {
                this.func_75651_a((Entity)this.field_75659_a.func_70638_az(), this.field_75659_a.func_184649_cE(), this.field_75659_a.func_70646_bf());
            }
        }

        private boolean isNotGettingAttackedByAWolf() {
            return !(this.field_75659_a.func_94060_bK() instanceof WolfEntity);
        }
    }
}

