/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.projectiles;

import com.infamous.dungeons_mobs.entities.projectiles.CobwebTrapEntity;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.utils.GeomancyHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class CobwebProjectileEntity
extends DamagingProjectileEntity
implements IRendersAsItem {
    private static final DataParameter<ItemStack> STACK = EntityDataManager.func_187226_a(CobwebProjectileEntity.class, (IDataSerializer)DataSerializers.field_187196_f);

    public CobwebProjectileEntity(World worldIn) {
        super((EntityType)ModEntityTypes.SLIMEBALL.get(), worldIn);
    }

    public CobwebProjectileEntity(EntityType<? extends CobwebProjectileEntity> entityType, World world) {
        super(entityType, world);
    }

    public CobwebProjectileEntity(World world, double x, double y, double z, double accelX, double accelY, double accelZ) {
        super((EntityType)ModEntityTypes.COBWEB_PROJECTILE.get(), x, y, z, accelX, accelY, accelZ, world);
    }

    public CobwebProjectileEntity(World world, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super((EntityType)ModEntityTypes.COBWEB_PROJECTILE.get(), shooter, accelX, accelY, accelZ, world);
    }

    public void setStack(ItemStack stack) {
        if (stack.func_77973_b() != Items.field_221672_ax || stack.func_77942_o()) {
            this.func_184212_Q().func_187227_b(STACK, Util.func_200696_a((Object)stack.func_77946_l(), itemStack -> itemStack.func_190920_e(1)));
        }
    }

    protected ItemStack getStack() {
        return (ItemStack)this.func_184212_Q().func_187225_a(STACK);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack func_184543_l() {
        ItemStack itemstack = this.getStack();
        return itemstack.func_190926_b() ? new ItemStack((IItemProvider)Items.field_221672_ax) : itemstack;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(STACK, (Object)ItemStack.field_190927_a);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        ItemStack itemstack = this.getStack();
        if (!itemstack.func_190926_b()) {
            compound.func_218657_a("Item", (INBT)itemstack.func_77955_b(new CompoundNBT()));
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        ItemStack itemstack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("Item"));
        this.setStack(itemstack);
    }

    protected boolean func_184564_k() {
        return false;
    }

    protected IParticleData func_195057_f() {
        return ParticleTypes.field_197614_g;
    }

    protected void func_213868_a(EntityRayTraceResult rayTraceResult) {
        BlockPos blockPos;
        super.func_213868_a(rayTraceResult);
        Entity entity = rayTraceResult.func_216348_a();
        if (!(entity instanceof SpiderEntity) && GeomancyHelper.canAllowBlockEntitySpawn((Entity)this, blockPos = entity.func_233580_cy_())) {
            this.createCobweb(blockPos);
        }
    }

    private void createCobweb(BlockPos blockPos) {
        CobwebTrapEntity cobwebTrapEntity = new CobwebTrapEntity(this.field_70170_p, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), 100);
        this.field_70170_p.func_217376_c((Entity)cobwebTrapEntity);
    }

    protected void func_230299_a_(BlockRayTraceResult rayTraceResult) {
        super.func_230299_a_(rayTraceResult);
        BlockPos blockPos = rayTraceResult.func_216350_a().func_177972_a(this.func_184172_bi().func_176734_d());
        if (GeomancyHelper.canAllowBlockEntitySpawn((Entity)this, blockPos)) {
            this.createCobweb(blockPos);
        }
    }

    protected void func_70227_a(RayTraceResult result) {
        super.func_70227_a(result);
        this.removeIfWorldNotRemote();
    }

    private void removeIfWorldNotRemote() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

