/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.renderer.water;

import com.infamous.dungeons_mobs.client.renderer.water.CustomDrownedOuterLayer;
import com.infamous.dungeons_mobs.interfaces.IArmoredMob;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.entity.AbstractZombieRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.DrownedModel;
import net.minecraft.client.renderer.entity.model.ZombieModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;

public class CustomDrownedRenderer
extends AbstractZombieRenderer<DrownedEntity, DrownedModel<DrownedEntity>> {
    private static final ResourceLocation DROWNED_LOCATION = new ResourceLocation("textures/entity/zombie/drowned.png");
    private static final ResourceLocation SEAWEED_ARMORED_DROWNED_LOCATION = new ResourceLocation("dungeons_mobs", "textures/entity/ocean/seaweed_armored_drowned.png");
    private static final ResourceLocation PALE_ARMORED_DROWNED_LOCATION = new ResourceLocation("dungeons_mobs", "textures/entity/ocean/pale_armored_drowned.png");

    public CustomDrownedRenderer(EntityRendererManager rendererManager) {
        super(rendererManager, (ZombieModel)new DrownedModel(0.0f, 0.0f, 64, 64), (ZombieModel)new DrownedModel(0.5f, true), (ZombieModel)new DrownedModel(1.0f, true));
        this.func_177094_a(new CustomDrownedOuterLayer(this));
    }

    protected void scale(DrownedEntity drowned, MatrixStack matrixStack, float p_225620_3_) {
        if (drowned instanceof IArmoredMob) {
            float scaleFactor = 1.1f;
            matrixStack.func_227862_a_(scaleFactor, scaleFactor, scaleFactor);
        }
        super.func_225620_a_((LivingEntity)drowned, matrixStack, p_225620_3_);
    }

    protected void setupRotations(DrownedEntity drowned, MatrixStack matrixStack, float p_225621_3_, float p_225621_4_, float p_225621_5_) {
        super.func_225621_a_((LivingEntity)drowned, matrixStack, p_225621_3_, p_225621_4_, p_225621_5_);
        float swimAmount = drowned.func_205015_b(p_225621_5_);
        if (swimAmount > 0.0f) {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(MathHelper.func_219799_g((float)swimAmount, (float)drowned.field_70125_A, (float)(-10.0f - drowned.field_70125_A))));
        }
    }

    public ResourceLocation getTextureLocation(DrownedEntity drowned) {
        if (drowned instanceof IArmoredMob) {
            if (((IArmoredMob)drowned).hasStrongArmor()) {
                return PALE_ARMORED_DROWNED_LOCATION;
            }
            return SEAWEED_ARMORED_DROWNED_LOCATION;
        }
        return DROWNED_LOCATION;
    }
}

