/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.renderer.illager;

import com.infamous.dungeons_mobs.client.models.armor.IllagerArmorModel;
import com.infamous.dungeons_mobs.client.models.illager.IllagerBipedModel;
import com.infamous.dungeons_mobs.entities.illagers.ArmoredVindicatorEntity;
import com.infamous.dungeons_mobs.entities.illagers.RoyalGuardEntity;
import com.infamous.dungeons_mobs.entities.illagers.VindicatorChefEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.HeadLayer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.VindicatorEntity;
import net.minecraft.util.ResourceLocation;

public class CustomVindicatorRenderer
extends MobRenderer<VindicatorEntity, IllagerBipedModel<VindicatorEntity>> {
    private static final ResourceLocation GOLD_ARMORED_VINDICATOR_TEXTURE = new ResourceLocation("dungeons_mobs", "textures/entity/illager/gold_armored_vindicator.png");
    private static final ResourceLocation DIAMOND_ARMORED_VINDICATOR_TEXTURE = new ResourceLocation("dungeons_mobs", "textures/entity/illager/diamond_armored_vindicator.png");
    private static final ResourceLocation VINDICATOR_TEXTURE = new ResourceLocation("textures/entity/illager/vindicator.png");
    private static final ResourceLocation ROYAL_GUARD_TEXTURE = new ResourceLocation("dungeons_mobs", "textures/entity/illager/royal_guard.png");
    private static final ResourceLocation VINDICATOR_CHEF_TEXTURE = new ResourceLocation("dungeons_mobs", "textures/entity/illager/vindicator_chef.png");

    public CustomVindicatorRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new IllagerBipedModel(0.0f, 0.0f, 64, 64), 0.5f);
        this.func_177094_a((LayerRenderer)new HeadLayer((IEntityRenderer)this));
        this.func_177094_a((LayerRenderer)new BipedArmorLayer((IEntityRenderer)this, (BipedModel)new IllagerArmorModel(0.5f), (BipedModel)new IllagerArmorModel(1.0f)));
        this.func_177094_a((LayerRenderer)new HeldItemLayer<VindicatorEntity, IllagerBipedModel<VindicatorEntity>>((IEntityRenderer)this){

            public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, VindicatorEntity vindicatorEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                if (vindicatorEntity.func_213398_dR() || vindicatorEntity.func_193077_p() == AbstractIllagerEntity.ArmPose.NEUTRAL) {
                    super.func_225628_a_(matrixStackIn, bufferIn, packedLightIn, (LivingEntity)vindicatorEntity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                }
            }
        });
    }

    protected void scale(VindicatorEntity vindicatorEntity, MatrixStack matrixStack, float v) {
        if (vindicatorEntity instanceof ArmoredVindicatorEntity) {
            float scaleFactor = 1.1f;
            matrixStack.func_227862_a_(scaleFactor, scaleFactor, scaleFactor);
        } else {
            float scaleFactor = 0.9375f;
            matrixStack.func_227862_a_(scaleFactor, scaleFactor, scaleFactor);
        }
        super.func_225620_a_((LivingEntity)vindicatorEntity, matrixStack, v);
    }

    public ResourceLocation getTextureLocation(VindicatorEntity entity) {
        if (entity.getClass() == ArmoredVindicatorEntity.class) {
            ArmoredVindicatorEntity armoredVindicatorEntity = (ArmoredVindicatorEntity)entity;
            if (armoredVindicatorEntity.isDiamond()) {
                return DIAMOND_ARMORED_VINDICATOR_TEXTURE;
            }
            return GOLD_ARMORED_VINDICATOR_TEXTURE;
        }
        if (entity instanceof RoyalGuardEntity) {
            return ROYAL_GUARD_TEXTURE;
        }
        if (entity instanceof VindicatorChefEntity) {
            return VINDICATOR_CHEF_TEXTURE;
        }
        return VINDICATOR_TEXTURE;
    }
}

