/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs;

import java.util.function.Supplier;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="dungeons_mobs", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DungeonsGearCompat {
    public static final String DUNGEONS_GEAR_MOD_ID = "dungeons_gear";
    private static boolean IS_LOADED = false;
    private static Supplier<Item> GOLD_AXE = () -> Items.field_190931_a;
    private static Supplier<Item> FIREBRAND = () -> Items.field_190931_a;
    private static Supplier<Item> RED_SNAKE = () -> Items.field_190931_a;
    private static Supplier<Item> STONE_SWORD = () -> Items.field_190931_a;
    private static Supplier<Item> HEAVY_CROSSBOW = () -> Items.field_190931_a;
    private static Supplier<Item> ELITE_POWER_BOW = () -> Items.field_190931_a;
    private static Supplier<Item> SOUL_KNIFE = () -> Items.field_190931_a;
    private static Supplier<Item> ETERNAL_KNIFE = () -> Items.field_190931_a;

    @SubscribeEvent
    public static void onInterMod(InterModProcessEvent event) {
        if (ModList.get().isLoaded(DUNGEONS_GEAR_MOD_ID)) {
            IS_LOADED = true;
            GOLD_AXE = () -> DungeonsGearCompat.getRegisteredItem("gold_axe");
            FIREBRAND = () -> DungeonsGearCompat.getRegisteredItem("firebrand");
            RED_SNAKE = () -> DungeonsGearCompat.getRegisteredItem("red_snake");
            STONE_SWORD = () -> DungeonsGearCompat.getRegisteredItem("stone_sword");
            HEAVY_CROSSBOW = () -> DungeonsGearCompat.getRegisteredItem("heavy_crossbow");
            ELITE_POWER_BOW = () -> DungeonsGearCompat.getRegisteredItem("elite_power_bow");
            SOUL_KNIFE = () -> DungeonsGearCompat.getRegisteredItem("soul_knife");
            ETERNAL_KNIFE = () -> DungeonsGearCompat.getRegisteredItem("eternal_knife");
        }
    }

    private static Item getRegisteredItem(String item) {
        return (Item)ForgeRegistries.ITEMS.getValue(DungeonsGearCompat.getDungeonsGearResource(item));
    }

    public static Item getOrDefault(Supplier<Item> dungeonsItemSupplier, Item defaultTo) {
        Item dungeonsItem = dungeonsItemSupplier.get();
        if (dungeonsItem == Items.field_190931_a) {
            return defaultTo;
        }
        return dungeonsItem;
    }

    public static Supplier<Item> getGoldAxe() {
        return GOLD_AXE;
    }

    public static Supplier<Item> getFirebrand() {
        return FIREBRAND;
    }

    public static Supplier<Item> getRedSnake() {
        return RED_SNAKE;
    }

    public static Supplier<Item> getStoneSword() {
        return STONE_SWORD;
    }

    public static Supplier<Item> getHeavyCrossbow() {
        return HEAVY_CROSSBOW;
    }

    public static Supplier<Item> getElitePowerBow() {
        return ELITE_POWER_BOW;
    }

    public static Supplier<Item> getSoulKnife() {
        return SOUL_KNIFE;
    }

    public static Supplier<Item> getEternalKnife() {
        return ETERNAL_KNIFE;
    }

    public static boolean isLoaded() {
        return IS_LOADED;
    }

    private static ResourceLocation getDungeonsGearResource(String itemId) {
        return new ResourceLocation(DUNGEONS_GEAR_MOD_ID, itemId);
    }
}

