/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.core.other;

import com.google.common.collect.Sets;
import com.minecraftabnormals.abnormals_core.common.world.storage.tracking.IDataManager;
import com.minecraftabnormals.abnormals_core.core.util.MathUtil;
import com.minecraftabnormals.environmental.api.IEggLayingEntity;
import com.minecraftabnormals.environmental.common.block.HangingWisteriaLeavesBlock;
import com.minecraftabnormals.environmental.common.entity.KoiEntity;
import com.minecraftabnormals.environmental.common.entity.SlabfishEntity;
import com.minecraftabnormals.environmental.common.entity.goals.HuntTruffleGoal;
import com.minecraftabnormals.environmental.common.entity.goals.LayEggInNestGoal;
import com.minecraftabnormals.environmental.common.entity.goals.TemptGoldenCarrotGoal;
import com.minecraftabnormals.environmental.common.entity.util.SlabfishOverlay;
import com.minecraftabnormals.environmental.common.slabfish.SlabfishManager;
import com.minecraftabnormals.environmental.core.EnvironmentalConfig;
import com.minecraftabnormals.environmental.core.other.EnvironmentalDataProcessors;
import com.minecraftabnormals.environmental.core.other.EnvironmentalTags;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalEntities;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalItems;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalParticles;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.NonTamedTargetGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.HuskEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.StrayEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.MooshroomEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="environmental")
public class EnvironmentalEvents {
    protected static final Set<Block> DIRT_SPREADABLES = Sets.newHashSet((Object[])new Block[]{Blocks.field_196658_i, Blocks.field_150391_bh});

    @SubscribeEvent
    public static void onPlayerBreak(PlayerEvent.BreakSpeed event) {
        if (event.getState().func_177230_c() instanceof HangingWisteriaLeavesBlock && event.getPlayer().func_184614_ca().func_77973_b() == Items.field_151097_aZ) {
            event.setNewSpeed(15.0f);
        }
    }

    @SubscribeEvent
    public static void onLivingSpawn(LivingSpawnEvent.CheckSpawn event) {
        boolean blockOnlyNaturalSpawns;
        Entity entity = event.getEntity();
        IWorld world = event.getWorld();
        Random random = world.func_201674_k();
        boolean naturalSpawn = event.getSpawnReason() == SpawnReason.NATURAL;
        boolean chunkGenSpawn = event.getSpawnReason() == SpawnReason.CHUNK_GENERATION;
        boolean validSpawn = naturalSpawn || chunkGenSpawn;
        boolean replaceVariants = (Boolean)EnvironmentalConfig.COMMON.biomeVariantsAlwaysSpawn.get();
        if (event.getResult() != Event.Result.DENY && world instanceof IServerWorld) {
            IServerWorld serverWorld = (IServerWorld)world;
            if (replaceVariants && validSpawn && entity.func_226278_cu_() > 60.0) {
                if (entity.func_200600_R() == EntityType.field_200725_aD) {
                    ZombieEntity zombie = (ZombieEntity)entity;
                    if (world.func_226691_t_(entity.func_233580_cy_()).func_201856_r() == Biome.Category.DESERT) {
                        HuskEntity husk = (HuskEntity)EntityType.field_200763_C.func_200721_a((World)serverWorld.func_201672_e());
                        husk.func_82227_f(zombie.func_70631_g_());
                        for (EquipmentSlotType equipmentSlotType : EquipmentSlotType.values()) {
                            zombie.func_184201_a(equipmentSlotType, zombie.func_184582_a(equipmentSlotType));
                        }
                        husk.func_70012_b(zombie.func_226277_ct_(), zombie.func_226278_cu_(), zombie.func_226281_cx_(), zombie.field_70177_z, zombie.field_70125_A);
                        world.func_217376_c((Entity)husk);
                        entity.func_70106_y();
                    }
                }
                if (entity.func_200600_R() == EntityType.field_200741_ag) {
                    SkeletonEntity skeleton = (SkeletonEntity)entity;
                    if (world.func_226691_t_(entity.func_233580_cy_()).func_201856_r() == Biome.Category.ICY) {
                        StrayEntity stray = (StrayEntity)EntityType.field_200750_ap.func_200721_a((World)serverWorld.func_201672_e());
                        for (EquipmentSlotType equipmentSlotType : EquipmentSlotType.values()) {
                            skeleton.func_184201_a(equipmentSlotType, skeleton.func_184582_a(equipmentSlotType));
                        }
                        stray.func_70012_b(skeleton.func_226277_ct_(), skeleton.func_226278_cu_(), skeleton.func_226281_cx_(), skeleton.field_70177_z, skeleton.field_70125_A);
                        world.func_217376_c((Entity)stray);
                        entity.func_70106_y();
                    }
                }
            }
            if (validSpawn && entity.func_200600_R() == EntityType.field_200780_T) {
                MooshroomEntity mooshroom = (MooshroomEntity)event.getEntity();
                if (random.nextInt(3) == 0) {
                    MooshroomEntity brownMooshroom = (MooshroomEntity)EntityType.field_200780_T.func_200721_a((World)serverWorld.func_201672_e());
                    brownMooshroom.func_70012_b(mooshroom.func_226277_ct_(), mooshroom.func_226278_cu_(), mooshroom.func_226281_cx_(), mooshroom.field_70177_z, mooshroom.field_70125_A);
                    brownMooshroom.func_213446_a(MooshroomEntity.Type.BROWN);
                    world.func_217376_c((Entity)brownMooshroom);
                    entity.func_70106_y();
                }
            }
        }
        if ((blockOnlyNaturalSpawns = ((Boolean)EnvironmentalConfig.COMMON.blockOnlyNaturalSpawns.get()).booleanValue()) && event.isSpawner()) {
            return;
        }
        if (!EnvironmentalTags.EntityTypes.UNAFFECTED_BY_SERENITY.func_230235_a_((Object)entity.func_200600_R()) && entity.func_200600_R().func_220339_d() == EntityClassification.MONSTER) {
            int horizontalRange = (Integer)EnvironmentalConfig.COMMON.koiHorizontalSerenityRange.get();
            int verticalRange = (Integer)EnvironmentalConfig.COMMON.koiVerticalSerenityRange.get();
            for (Entity koi : world.func_217357_a(KoiEntity.class, entity.func_174813_aQ().func_72314_b((double)horizontalRange, (double)verticalRange, (double)horizontalRange))) {
                if (!(MathUtil.distanceBetweenPoints2d((double)entity.func_226277_ct_(), (double)entity.func_226281_cx_(), (double)koi.func_226277_ct_(), (double)koi.func_226281_cx_()) <= (double)horizontalRange)) continue;
                event.setResult(Event.Result.DENY);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent.Throwable event) {
        ThrowableEntity projectileEntity = event.getThrowable();
        if (projectileEntity instanceof PotionEntity) {
            AxisAlignedBB axisalignedbb;
            List slabs;
            PotionEntity potionEntity = (PotionEntity)projectileEntity;
            ItemStack itemstack = potionEntity.func_184543_l();
            Potion potion = PotionUtils.func_185191_c((ItemStack)itemstack);
            List list = PotionUtils.func_185189_a((ItemStack)itemstack);
            if (potion == Potions.field_185230_b && list.isEmpty() && !(slabs = potionEntity.field_70170_p.func_217357_a(SlabfishEntity.class, axisalignedbb = potionEntity.func_174813_aQ().func_72314_b(2.0, 1.0, 2.0))).isEmpty()) {
                for (SlabfishEntity slabfish : slabs) {
                    slabfish.setSlabfishOverlay(SlabfishOverlay.NONE);
                }
            }
        }
        if (projectileEntity instanceof ProjectileItemEntity) {
            EntityRayTraceResult entity;
            ProjectileItemEntity projectileitem = (ProjectileItemEntity)projectileEntity;
            if (event.getRayTraceResult() != null && event.getRayTraceResult().func_216346_c() == RayTraceResult.Type.ENTITY && (entity = (EntityRayTraceResult)event.getRayTraceResult()).func_216348_a() instanceof SlabfishEntity) {
                SlabfishEntity slabfish = (SlabfishEntity)entity.func_216348_a();
                Item item = projectileitem.func_184543_l().func_77973_b();
                if (item == Items.field_151126_ay) {
                    slabfish.setSlabfishOverlay(SlabfishOverlay.SNOWY);
                } else if (item.func_206844_a((ITag)Tags.Items.EGGS)) {
                    slabfish.setSlabfishOverlay(SlabfishOverlay.EGG);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        BlockState state = world.func_180495_p(pos);
        Direction face = event.getFace();
        PlayerEntity player = event.getPlayer();
        ItemStack stack = event.getItemStack();
        Item item = stack.func_77973_b();
        if (item == Items.field_196106_bc && state.func_177230_c() == Blocks.field_150346_d && world.func_180495_p(pos.func_177984_a()).func_200131_a((IBlockReader)world, pos)) {
            ArrayList<BlockState> potentialStates = new ArrayList<BlockState>();
            for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-1, -1, -1), (BlockPos)pos.func_177982_a(1, 1, 1))) {
                Block block = world.func_180495_p(blockpos).func_177230_c();
                if (!DIRT_SPREADABLES.contains(block) || potentialStates.contains(block.func_176223_P())) continue;
                potentialStates.add(block.func_176223_P());
            }
            if (!potentialStates.isEmpty()) {
                if (!world.func_201670_d()) {
                    world.func_217379_c(2005, pos, 0);
                    world.func_180501_a(pos, (BlockState)potentialStates.get(world.func_201674_k().nextInt(potentialStates.size())), 3);
                }
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                event.setCancellationResult(ActionResultType.func_233537_a_((boolean)world.func_201670_d()));
                event.setCanceled(true);
            }
        } else if (item instanceof ShovelItem && !player.func_175149_v() && state.func_203425_a((Block)EnvironmentalBlocks.BURIED_TRUFFLE.get())) {
            Vector3i vector3i = face.func_176730_m();
            double d0 = (double)pos.func_177958_n() + 0.5 + 0.625 * (double)vector3i.func_177958_n();
            double d1 = (double)pos.func_177956_o() + 0.375 + 0.625 * (double)vector3i.func_177956_o();
            double d2 = (double)pos.func_177952_p() + 0.5 + 0.625 * (double)vector3i.func_177952_p();
            ItemEntity itementity = new ItemEntity(world, d0, d1, d2, new ItemStack((IItemProvider)EnvironmentalItems.TRUFFLE.get()));
            world.func_217376_c((Entity)itementity);
            world.func_184133_a(player, pos, (SoundEvent)EnvironmentalSounds.SHOVEL_DIG.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            stack.func_222118_a(1, (LivingEntity)player, damage -> damage.func_213334_d(event.getHand()));
            world.func_180501_a(pos, Blocks.field_150346_d.func_176223_P(), 11);
            event.setCancellationResult(ActionResultType.func_233537_a_((boolean)world.func_201670_d()));
            event.setCanceled(true);
        } else if (event.getFace() != Direction.DOWN && item instanceof ShovelItem && !player.func_175149_v() && world.func_175623_d(pos.func_177984_a()) && (state.func_203425_a(Blocks.field_196661_l) || state.func_203425_a(Blocks.field_150391_bh))) {
            world.func_184133_a(player, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
            stack.func_222118_a(1, (LivingEntity)player, damage -> damage.func_213334_d(event.getHand()));
            world.func_180501_a(pos, state.func_203425_a(Blocks.field_196661_l) ? ((Block)EnvironmentalBlocks.PODZOL_PATH.get()).func_176223_P() : ((Block)EnvironmentalBlocks.MYCELIUM_PATH.get()).func_176223_P(), 11);
            event.setCancellationResult(ActionResultType.func_233537_a_((boolean)world.func_201670_d()));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        IDataManager data;
        ItemStack stack = event.getItemStack();
        Entity target = event.getTarget();
        World world = event.getWorld();
        Random random = world.func_201674_k();
        if (target instanceof SlabfishEntity && stack.func_77973_b() == Items.field_151057_cb) {
            SlabfishEntity slabby = (SlabfishEntity)event.getTarget();
            if (!(!stack.func_82837_s() || slabby.func_145818_k_() && slabby.func_200201_e() != null && slabby.func_200201_e().getString().equals(stack.func_200301_q().getString()))) {
                slabby.playTransformSound();
            }
        }
        if (target instanceof PigEntity && stack.func_77973_b() == Items.field_151150_bK && target.func_70089_S() && !((PigEntity)target).func_70631_g_() && (Integer)(data = (IDataManager)target).getValue(EnvironmentalDataProcessors.TRUFFLE_HUNTING_TIME) == 0) {
            if (world.func_230315_m_().func_236043_f_()) {
                data.setValue(EnvironmentalDataProcessors.TRUFFLE_HUNTING_TIME, (Object)4800);
                if (!event.getPlayer().func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                if (world.func_201670_d()) {
                    for (int i = 0; i < 7; ++i) {
                        double d0 = random.nextGaussian() * 0.02;
                        double d1 = random.nextGaussian() * 0.02;
                        double d2 = random.nextGaussian() * 0.02;
                        world.func_195594_a((IParticleData)EnvironmentalParticles.PIG_FINDS_TRUFFLE.get(), target.func_226282_d_(1.0), target.func_226279_cv_() + 0.5, target.func_226287_g_(1.0), d0, d1, d2);
                    }
                }
            } else if (world.func_201670_d()) {
                for (int i = 0; i < 7; ++i) {
                    double d0 = random.nextGaussian() * 0.02;
                    double d1 = random.nextGaussian() * 0.02;
                    double d2 = random.nextGaussian() * 0.02;
                    world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, target.func_226282_d_(1.0), target.func_226279_cv_() + 0.5, target.func_226287_g_(1.0), d0, d1, d2);
                }
            }
            event.setCancellationResult(ActionResultType.func_233537_a_((boolean)world.func_201670_d()));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntityLiving();
        World world = entity.func_130014_f_();
        Random rand = new Random();
        if (entity instanceof SlabfishEntity) {
            SlabfishEntity slabfish = (SlabfishEntity)event.getEntity();
            if (world.func_242406_i(new BlockPos(entity.func_213303_ch())).equals(Optional.of(Biomes.field_235252_ay_)) && !slabfish.getSlabfishType().equals((Object)SlabfishManager.GHOST)) {
                if (world.func_201670_d()) {
                    for (int i = 0; i < 7; ++i) {
                        double d0 = rand.nextGaussian() * 0.02;
                        double d1 = rand.nextGaussian() * 0.02;
                        double d2 = rand.nextGaussian() * 0.02;
                        world.func_195594_a((IParticleData)ParticleTypes.field_239812_C_, entity.func_226282_d_(1.0), entity.func_226279_cv_() + 0.5, entity.func_226287_g_(1.0), d0, d1, d2);
                    }
                }
                if (!world.func_201670_d()) {
                    SlabfishEntity ghost = (SlabfishEntity)((EntityType)EnvironmentalEntities.SLABFISH.get()).func_200721_a(world);
                    if (ghost == null) {
                        return;
                    }
                    ghost.func_195064_c(new EffectInstance(Effects.field_188424_y, 140, 0, false, false));
                    ghost.func_195064_c(new EffectInstance(Effects.field_76426_n, 140, 0, false, false));
                    world.func_184133_a(null, new BlockPos(entity.func_213303_ch()), SoundEvents.field_190021_aL, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    ghost.func_70107_b(slabfish.func_226277_ct_(), slabfish.func_226278_cu_(), slabfish.func_226281_cx_());
                    ghost.func_70012_b(slabfish.func_226277_ct_(), slabfish.func_226278_cu_(), slabfish.func_226281_cx_(), slabfish.field_70177_z, slabfish.field_70125_A);
                    ghost.func_94061_f(slabfish.func_175446_cd());
                    ghost.func_70873_a(slabfish.func_70874_b());
                    ghost.setSlabfishType(SlabfishManager.GHOST);
                    ghost.func_70015_d(0);
                    if (slabfish.func_145818_k_()) {
                        ghost.func_200203_b(entity.func_200201_e());
                        ghost.func_174805_g(entity.func_174833_aM());
                    }
                    world.func_217376_c((Entity)ghost);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBabySpawn(BabyEntitySpawnEvent event) {
        if (event.getParentA() instanceof PigEntity && event.getParentB() instanceof PigEntity) {
            PigEntity pig = (PigEntity)event.getParentA();
            World world = pig.func_130014_f_();
            int piglets = world.field_73012_v.nextInt(4);
            for (int i = 0; i < piglets; ++i) {
                PigEntity baby = (PigEntity)EntityType.field_200784_X.func_200721_a(world);
                if (baby == null) continue;
                baby.func_82227_f(true);
                baby.func_70012_b(pig.func_226277_ct_(), pig.func_226278_cu_(), pig.func_226281_cx_(), 0.0f, 0.0f);
                world.func_217376_c((Entity)baby);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof IEggLayingEntity && entity instanceof AnimalEntity) {
            AnimalEntity eggLayer = (AnimalEntity)entity;
            if (eggLayer.field_70714_bg.field_220892_d.stream().noneMatch(goal -> goal.func_220772_j() instanceof LayEggInNestGoal)) {
                eggLayer.field_70714_bg.func_75776_a(3, (Goal)new LayEggInNestGoal(eggLayer, 1.0));
            }
        } else if (entity instanceof WolfEntity) {
            WolfEntity wolf = (WolfEntity)entity;
            wolf.field_70715_bh.func_75776_a(4, (Goal)new NonTamedTargetGoal((TameableEntity)wolf, AnimalEntity.class, false, targetEntity -> targetEntity.func_200600_R() == EnvironmentalEntities.DEER.get()));
        } else if (entity instanceof OcelotEntity) {
            OcelotEntity ocelot = (OcelotEntity)entity;
            ocelot.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)ocelot, AnimalEntity.class, 10, false, false, targetEntity -> targetEntity.func_200600_R() == EnvironmentalEntities.DUCK.get()));
        } else if (entity instanceof PigEntity) {
            PigEntity pig = (PigEntity)entity;
            Set goals = pig.field_70714_bg.field_220892_d;
            if (goals.stream().noneMatch(goal -> goal.func_220772_j() instanceof HuntTruffleGoal)) {
                pig.field_70714_bg.func_75776_a(2, (Goal)new HuntTruffleGoal(pig));
            }
            if ((pig.func_70661_as() instanceof GroundPathNavigator || pig.func_70661_as() instanceof FlyingPathNavigator) && goals.stream().noneMatch(goal -> goal.func_220772_j() instanceof TemptGoldenCarrotGoal)) {
                pig.field_70714_bg.func_75776_a(4, (Goal)new TemptGoldenCarrotGoal((CreatureEntity)pig, 1.2, false, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151150_bK})));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        Entity entity = event.getEntity();
        World world = entity.func_130014_f_();
        Random random = world.func_201674_k();
        if (entity instanceof PigEntity && entity.func_70089_S()) {
            IDataManager data = (IDataManager)entity;
            int huntingtime = (Integer)data.getValue(EnvironmentalDataProcessors.TRUFFLE_HUNTING_TIME);
            BlockPos trufflepos = (BlockPos)data.getValue(EnvironmentalDataProcessors.TRUFFLE_POS);
            if (huntingtime == 0 || ((Boolean)data.getValue(EnvironmentalDataProcessors.HAS_TRUFFLE_TARGET)).booleanValue() && world.func_180495_p(trufflepos).func_177230_c() != EnvironmentalBlocks.BURIED_TRUFFLE.get()) {
                data.setValue(EnvironmentalDataProcessors.HAS_TRUFFLE_TARGET, (Object)false);
                if (huntingtime > 0) {
                    data.setValue(EnvironmentalDataProcessors.TRUFFLE_HUNTING_TIME, (Object)Math.max(-400, -huntingtime));
                }
            } else if (huntingtime > 0) {
                data.setValue(EnvironmentalDataProcessors.TRUFFLE_HUNTING_TIME, (Object)(huntingtime - 1));
            } else if (huntingtime < 0) {
                data.setValue(EnvironmentalDataProcessors.TRUFFLE_HUNTING_TIME, (Object)(huntingtime + 1));
                if (world.func_201670_d() && ((Boolean)data.getValue(EnvironmentalDataProcessors.HAS_TRUFFLE_TARGET)).booleanValue() && huntingtime % 10 == 0) {
                    double d0 = random.nextGaussian() * 0.02;
                    double d1 = random.nextGaussian() * 0.02;
                    double d2 = random.nextGaussian() * 0.02;
                    world.func_195594_a((IParticleData)EnvironmentalParticles.PIG_FINDS_TRUFFLE.get(), entity.func_226282_d_(1.0), entity.func_226279_cv_() + 0.5, entity.func_226287_g_(1.0), d0, d1, d2);
                }
            }
            int sniffsoundtime = (Integer)data.getValue(EnvironmentalDataProcessors.SNIFF_SOUND_TIME);
            data.setValue(EnvironmentalDataProcessors.SNIFF_SOUND_TIME, (Object)(sniffsoundtime + 1));
            if (!world.func_201670_d() && ((Boolean)data.getValue(EnvironmentalDataProcessors.LOOKING_FOR_TRUFFLE)).booleanValue() && random.nextInt(60) < sniffsoundtime) {
                entity.func_184185_a((SoundEvent)EnvironmentalSounds.PIG_SNIFF.get(), 1.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f);
                data.setValue(EnvironmentalDataProcessors.SNIFF_SOUND_TIME, (Object)-20);
            }
        }
    }
}

