/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.common.slabfish;

import com.minecraftabnormals.environmental.common.entity.util.SlabfishRarity;
import com.minecraftabnormals.environmental.common.slabfish.BackpackType;
import com.minecraftabnormals.environmental.common.slabfish.ClientSlabfishManager;
import com.minecraftabnormals.environmental.common.slabfish.SlabfishLoader;
import com.minecraftabnormals.environmental.common.slabfish.SlabfishType;
import com.minecraftabnormals.environmental.common.slabfish.SweaterType;
import com.minecraftabnormals.environmental.common.slabfish.condition.SlabfishCondition;
import com.minecraftabnormals.environmental.common.slabfish.condition.SlabfishConditionContext;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.fml.LogicalSide;

public interface SlabfishManager {
    public static final SlabfishType DEFAULT_SLABFISH = new SlabfishType(SlabfishRarity.COMMON, (ITextComponent)new TranslationTextComponent("entity.environmental.slabfish.type.swamp"), null, false, true, true, -1, new SlabfishCondition[0]).setRegistryName(new ResourceLocation("environmental", "swamp"));
    public static final SweaterType EMPTY_SWEATER = new SweaterType(null, Ingredient.field_193370_a).setRegistryName(new ResourceLocation("environmental", "empty"));
    public static final BackpackType BROWN_BACKPACK = new BackpackType(null, Ingredient.field_193370_a).setRegistryName(new ResourceLocation("environmental", "brown"));
    public static final ResourceLocation GHOST = new ResourceLocation("environmental", "ghost");

    public static SlabfishManager get(LogicalSide side) {
        return side.isClient() ? ClientSlabfishManager.INSTANCE : SlabfishLoader.instance;
    }

    public static SlabfishManager get(IWorldReader world) {
        return world.func_201670_d() ? ClientSlabfishManager.INSTANCE : SlabfishLoader.instance;
    }

    public Optional<SlabfishType> getSlabfishType(ResourceLocation var1);

    public Optional<SweaterType> getSweaterType(ResourceLocation var1);

    public Optional<BackpackType> getBackpackType(ResourceLocation var1);

    default public Optional<SlabfishType> getSlabfishType(SlabfishConditionContext context) {
        return this.getSlabfishType(__ -> true, context);
    }

    public Optional<SlabfishType> getSlabfishType(Predicate<SlabfishType> var1, SlabfishConditionContext var2);

    public Optional<SweaterType> getSweaterType(ItemStack var1);

    public Optional<BackpackType> getBackpackType(ItemStack var1);

    public Optional<SlabfishType> getRandomSlabfishType(Predicate<SlabfishType> var1, Random var2);

    public SlabfishType[] getAllSlabfishTypes();

    public SweaterType[] getAllSweaterTypes();

    public BackpackType[] getAllBackpackTypes();
}

