/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.common.slabfish;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.minecraftabnormals.environmental.common.network.message.SSyncBackpackTypeMessage;
import com.minecraftabnormals.environmental.common.network.message.SSyncSlabfishTypeMessage;
import com.minecraftabnormals.environmental.common.network.message.SSyncSweaterTypeMessage;
import com.minecraftabnormals.environmental.common.slabfish.BackpackType;
import com.minecraftabnormals.environmental.common.slabfish.SlabfishManager;
import com.minecraftabnormals.environmental.common.slabfish.SlabfishType;
import com.minecraftabnormals.environmental.common.slabfish.SweaterType;
import com.minecraftabnormals.environmental.common.slabfish.condition.SlabfishCondition;
import com.minecraftabnormals.environmental.common.slabfish.condition.SlabfishConditionContext;
import com.minecraftabnormals.environmental.core.Environmental;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SlabfishLoader
extends JsonReloadListener
implements SlabfishManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(ITextComponent.class, (Object)new ITextComponent.Serializer()).registerTypeAdapter(SlabfishType.class, (Object)new SlabfishType.Deserializer()).registerTypeAdapter(SlabfishCondition.class, (Object)new SlabfishCondition.Deserializer()).registerTypeAdapter(SweaterType.class, (Object)new SweaterType.Deserializer()).registerTypeAdapter(BackpackType.class, (Object)new BackpackType.Deserializer()).create();
    static SlabfishLoader instance;
    private final Map<ResourceLocation, SlabfishType> slabfishTypes = new HashMap<ResourceLocation, SlabfishType>();
    private final Map<ResourceLocation, SweaterType> sweaterTypes = new HashMap<ResourceLocation, SweaterType>();
    private final Map<ResourceLocation, BackpackType> backpackTypes = new HashMap<ResourceLocation, BackpackType>();

    public SlabfishLoader() {
        super(GSON, "slabfish");
        instance = this;
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, IResourceManager resourceManager, IProfiler profiler) {
        HashMap parsedSlabfishTypes = new HashMap();
        HashMap parsedSweaterTypes = new HashMap();
        HashMap<ResourceLocation, BackpackType> parsedBackpackTypes = new HashMap<ResourceLocation, BackpackType>();
        parsedBackpackTypes.put(BROWN_BACKPACK.getRegistryName(), BROWN_BACKPACK);
        object.forEach((location, json) -> {
            if (location.func_110623_a().startsWith("type")) {
                ResourceLocation registryName = new ResourceLocation(location.func_110624_b(), location.func_110623_a().substring("type/".length()));
                try {
                    parsedSlabfishTypes.put(registryName, ((SlabfishType)GSON.fromJson(json, SlabfishType.class)).setRegistryName(registryName));
                }
                catch (Exception e) {
                    LOGGER.error("Parsing error loading custom slabfish " + registryName, (Throwable)e);
                }
            } else if (location.func_110623_a().startsWith("sweater")) {
                ResourceLocation registryName = new ResourceLocation(location.func_110624_b(), location.func_110623_a().substring("sweater/".length()));
                try {
                    parsedSweaterTypes.put(registryName, ((SweaterType)GSON.fromJson(json, SweaterType.class)).setRegistryName(registryName));
                }
                catch (Exception e) {
                    LOGGER.error("Parsing error loading custom sweater " + registryName, (Throwable)e);
                }
            } else if (location.func_110623_a().startsWith("backpack")) {
                ResourceLocation registryName = new ResourceLocation(location.func_110624_b(), location.func_110623_a().substring("backpack/".length()));
                try {
                    parsedBackpackTypes.put(registryName, ((BackpackType)GSON.fromJson(json, BackpackType.class)).setRegistryName(registryName));
                }
                catch (Exception e) {
                    LOGGER.error("Parsing error loading custom backpack " + registryName, (Throwable)e);
                }
            }
        });
        LOGGER.info("Loaded " + parsedSlabfishTypes.size() + " Slabfish Types");
        LOGGER.info("Loaded " + parsedSweaterTypes.size() + " Sweater Types");
        LOGGER.info("Loaded " + parsedBackpackTypes.size() + " Backpack Types");
        this.slabfishTypes.clear();
        this.slabfishTypes.put(DEFAULT_SLABFISH.getRegistryName(), DEFAULT_SLABFISH);
        this.slabfishTypes.putAll(parsedSlabfishTypes);
        this.sweaterTypes.clear();
        this.sweaterTypes.put(EMPTY_SWEATER.getRegistryName(), EMPTY_SWEATER);
        this.sweaterTypes.putAll(parsedSweaterTypes);
        this.backpackTypes.clear();
        this.backpackTypes.putAll(parsedBackpackTypes);
        if (EffectiveSide.get().isServer()) {
            Environmental.PLAY.send(PacketDistributor.ALL.noArg(), (Object)new SSyncSlabfishTypeMessage());
            Environmental.PLAY.send(PacketDistributor.ALL.noArg(), (Object)new SSyncSweaterTypeMessage());
            Environmental.PLAY.send(PacketDistributor.ALL.noArg(), (Object)new SSyncBackpackTypeMessage());
        }
    }

    @Override
    public Optional<SlabfishType> getSlabfishType(ResourceLocation registryName) {
        return Optional.ofNullable(this.slabfishTypes.get(registryName));
    }

    @Override
    public Optional<SweaterType> getSweaterType(ResourceLocation registryName) {
        return Optional.ofNullable(this.sweaterTypes.get(registryName));
    }

    @Override
    public Optional<BackpackType> getBackpackType(ResourceLocation registryName) {
        return Optional.ofNullable(this.backpackTypes.get(registryName));
    }

    @Override
    public Optional<SlabfishType> getSlabfishType(Predicate<SlabfishType> predicate, SlabfishConditionContext context) {
        return this.slabfishTypes.values().stream().filter(slabfishType -> slabfishType != DEFAULT_SLABFISH && predicate.test((SlabfishType)slabfishType) && slabfishType.test(context)).max(Comparator.comparingInt(SlabfishType::getPriority));
    }

    @Override
    public Optional<SweaterType> getSweaterType(ItemStack stack) {
        return this.sweaterTypes.values().stream().filter(sweaterType -> sweaterType != EMPTY_SWEATER && sweaterType.test(stack)).findFirst();
    }

    @Override
    public Optional<BackpackType> getBackpackType(ItemStack stack) {
        return this.backpackTypes.values().stream().filter(backpackType -> backpackType.test(stack)).findFirst();
    }

    @Override
    public Optional<SlabfishType> getRandomSlabfishType(Predicate<SlabfishType> predicate, Random random) {
        SlabfishType[] slabfishTypes = (SlabfishType[])this.slabfishTypes.values().stream().filter(predicate).toArray(SlabfishType[]::new);
        return slabfishTypes.length == 0 ? Optional.empty() : Optional.of(slabfishTypes[random.nextInt(slabfishTypes.length)]);
    }

    @Override
    public SlabfishType[] getAllSlabfishTypes() {
        return this.slabfishTypes.values().toArray(new SlabfishType[0]);
    }

    @Override
    public SweaterType[] getAllSweaterTypes() {
        return this.sweaterTypes.values().toArray(new SweaterType[0]);
    }

    @Override
    public BackpackType[] getAllBackpackTypes() {
        return this.backpackTypes.values().toArray(new BackpackType[0]);
    }
}

