/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.common.network.message;

import com.minecraftabnormals.environmental.common.network.ClientNetworkHandler;
import com.minecraftabnormals.environmental.common.network.message.CAcknowledgeEnvironmentalMessage;
import com.minecraftabnormals.environmental.common.network.message.EnvironmentalLoginMessage;
import com.minecraftabnormals.environmental.common.slabfish.SlabfishManager;
import com.minecraftabnormals.environmental.common.slabfish.SweaterType;
import com.minecraftabnormals.environmental.core.Environmental;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class SSyncSweaterTypeMessage
implements EnvironmentalLoginMessage {
    private final SweaterType[] sweaterTypes;
    private int loginIndex;

    public SSyncSweaterTypeMessage() {
        this(SlabfishManager.get(LogicalSide.SERVER).getAllSweaterTypes());
    }

    private SSyncSweaterTypeMessage(SweaterType[] sweaterTypes) {
        this.sweaterTypes = sweaterTypes;
    }

    public static void serialize(SSyncSweaterTypeMessage msg, PacketBuffer buf) {
        buf.func_150787_b(msg.sweaterTypes.length);
        for (int i = 0; i < msg.sweaterTypes.length; ++i) {
            msg.sweaterTypes[i].writeTo(buf);
        }
    }

    public static SSyncSweaterTypeMessage deserialize(PacketBuffer buf) {
        SweaterType[] slabfishTypes = new SweaterType[buf.func_150792_a()];
        for (int i = 0; i < slabfishTypes.length; ++i) {
            slabfishTypes[i] = SweaterType.readFrom(buf);
        }
        return new SSyncSweaterTypeMessage(slabfishTypes);
    }

    public static void handlePlay(SSyncSweaterTypeMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientNetworkHandler.handleSyncSweaterType(msg, (NetworkEvent.Context)ctx.get()));
        ctx.get().setPacketHandled(true);
    }

    public static void handleLogin(SSyncSweaterTypeMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientNetworkHandler.handleSyncSweaterType(msg, (NetworkEvent.Context)ctx.get()));
        Environmental.LOGIN.reply((Object)new CAcknowledgeEnvironmentalMessage(), ctx.get());
        ctx.get().setPacketHandled(true);
    }

    public SweaterType[] getSweaterTypes() {
        return this.sweaterTypes;
    }

    @Override
    public int getLoginIndex() {
        return this.loginIndex;
    }

    @Override
    public void setLoginIndex(int loginIndex) {
        this.loginIndex = loginIndex;
    }
}

