/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.common.entity.util;

import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;

public enum SlabfishOverlay implements IStringSerializable
{
    NONE(0, "none"),
    MUDDY(1, "mud"),
    SNOWY(2, "snow"),
    EGG(3, "egg");

    private static final SlabfishOverlay[] VALUES;
    private final int id;
    private final String name;
    private final LazyValue<ResourceLocation> textureLocation = new LazyValue(() -> new ResourceLocation("environmental", "overlay/" + this.func_176610_l()));
    private final LazyValue<ResourceLocation> backpackTextureLocation = new LazyValue(() -> new ResourceLocation("environmental", "overlay/" + this.func_176610_l() + "_backpack"));

    private SlabfishOverlay(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public String func_176610_l() {
        return this.name;
    }

    public ResourceLocation getTextureLocation() {
        return (ResourceLocation)this.textureLocation.func_179281_c();
    }

    public ResourceLocation getBackpackTextureLocation() {
        return (ResourceLocation)this.backpackTextureLocation.func_179281_c();
    }

    public static SlabfishOverlay byId(int id) {
        if (id < 0 || id >= VALUES.length) {
            id = 0;
        }
        return VALUES[id];
    }

    public static SlabfishOverlay byTranslationKey(String key, SlabfishOverlay type) {
        for (SlabfishOverlay slabfishtype : SlabfishOverlay.values()) {
            if (!slabfishtype.name.equals(key)) continue;
            return slabfishtype;
        }
        return type;
    }

    static {
        VALUES = (SlabfishOverlay[])Arrays.stream(SlabfishOverlay.values()).sorted(Comparator.comparingInt(SlabfishOverlay::getId)).toArray(SlabfishOverlay[]::new);
    }
}

