/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.entityculling;

import com.logisticscraft.occlusionculling.OcclusionCullingInstance;
import com.logisticscraft.occlusionculling.util.Vec3d;
import dev.tr7zw.entityculling.EntityCullingModBase;
import dev.tr7zw.entityculling.access.Cullable;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.chunk.Chunk;

public class CullTask
implements Runnable {
    public boolean requestCull = false;
    private final OcclusionCullingInstance culling;
    private final Minecraft client = Minecraft.func_71410_x();
    private final int sleepDelay;
    private final int hitboxLimit;
    private final Set<TileEntityType<?>> blockEntityWhitelist;
    private final Set<EntityType<?>> entityWhistelist;
    public long lastTime;
    private Vec3d lastPos;
    private Vec3d aabbMin;
    private Vec3d aabbMax;

    public CullTask(OcclusionCullingInstance culling, Set<TileEntityType<?>> blockEntityWhitelist, Set<EntityType<?>> entityWhistelist) {
        this.sleepDelay = EntityCullingModBase.instance.config.sleepDelay;
        this.hitboxLimit = EntityCullingModBase.instance.config.hitboxLimit;
        this.lastTime = 0L;
        this.lastPos = new Vec3d(0.0, 0.0, 0.0);
        this.aabbMin = new Vec3d(0.0, 0.0, 0.0);
        this.aabbMax = new Vec3d(0.0, 0.0, 0.0);
        this.culling = culling;
        this.blockEntityWhitelist = blockEntityWhitelist;
        this.entityWhistelist = entityWhistelist;
    }

    @Override
    public void run() {
        while (this.client.func_228025_l_()) {
            try {
                Vector3d cameraMC;
                Thread.sleep(this.sleepDelay);
                if (!EntityCullingModBase.enabled || this.client.field_71441_e == null || this.client.field_71439_g == null || this.client.field_71439_g.field_70173_aa <= 10) continue;
                Vector3d vector3d = cameraMC = EntityCullingModBase.instance.config.debugMode ? this.client.field_71439_g.func_174824_e(this.client.func_193989_ak()) : this.client.field_71460_t.func_215316_n().func_216785_c();
                if (!this.requestCull && cameraMC.field_72450_a == this.lastPos.x && cameraMC.field_72448_b == this.lastPos.y && cameraMC.field_72449_c == this.lastPos.z) continue;
                long start = System.currentTimeMillis();
                this.requestCull = false;
                this.lastPos.set(cameraMC.field_72450_a, cameraMC.field_72448_b, cameraMC.field_72449_c);
                Vec3d camera = this.lastPos;
                this.culling.resetCache();
                boolean spectator = this.client.field_71439_g.func_175149_v();
                for (int x = -8; x <= 8; ++x) {
                    block8: for (int z = -8; z <= 8; ++z) {
                        Chunk chunk = this.client.field_71441_e.func_212866_a_(this.client.field_71439_g.field_70176_ah + x, this.client.field_71439_g.field_70164_aj + z);
                        Iterator iterator = chunk.func_177434_r().entrySet().iterator();
                        while (iterator.hasNext()) {
                            Cullable cullable;
                            Map.Entry entry;
                            try {
                                entry = iterator.next();
                            }
                            catch (NullPointerException | ConcurrentModificationException ex) {
                                continue block8;
                            }
                            if (this.blockEntityWhitelist.contains(((TileEntity)entry.getValue()).func_200662_C()) || EntityCullingModBase.instance.isDynamicWhitelisted((TileEntity)entry.getValue()) || (cullable = (Cullable)entry.getValue()).isForcedVisible()) continue;
                            if (spectator) {
                                cullable.setCulled(false);
                                continue;
                            }
                            BlockPos pos = (BlockPos)entry.getKey();
                            if (!pos.func_218137_a((IPosition)cameraMC, 64.0)) continue;
                            AxisAlignedBB boundingBox = EntityCullingModBase.instance.setupAABB((TileEntity)entry.getValue(), pos);
                            if (boundingBox.func_216364_b() > (double)this.hitboxLimit || boundingBox.func_216360_c() > (double)this.hitboxLimit || boundingBox.func_216362_d() > (double)this.hitboxLimit) {
                                cullable.setCulled(false);
                                continue;
                            }
                            this.aabbMin.set(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c);
                            this.aabbMax.set(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f);
                            boolean visible = this.culling.isAABBVisible(this.aabbMin, this.aabbMax, camera);
                            cullable.setCulled(!visible);
                        }
                    }
                }
                Entity entity = null;
                Iterator iterable = this.client.field_71441_e.func_217416_b().iterator();
                while (iterable.hasNext()) {
                    Cullable cullable;
                    try {
                        entity = (Entity)iterable.next();
                    }
                    catch (NullPointerException | ConcurrentModificationException ex) {
                        break;
                    }
                    if (entity == null || !(entity instanceof Cullable) || this.entityWhistelist.contains(entity.func_200600_R()) || EntityCullingModBase.instance.isDynamicWhitelisted(entity) || (cullable = (Cullable)entity).isForcedVisible()) continue;
                    if (spectator || entity.func_225510_bt_() || this.isSkippableArmorstand(entity)) {
                        cullable.setCulled(false);
                        continue;
                    }
                    if (!entity.func_213303_ch().func_237488_a_((IPosition)cameraMC, (double)EntityCullingModBase.instance.config.tracingDistance)) {
                        cullable.setCulled(false);
                        continue;
                    }
                    AxisAlignedBB boundingBox = entity.func_184177_bl();
                    if (boundingBox.func_216364_b() > (double)this.hitboxLimit || boundingBox.func_216360_c() > (double)this.hitboxLimit || boundingBox.func_216362_d() > (double)this.hitboxLimit) {
                        cullable.setCulled(false);
                        continue;
                    }
                    this.aabbMin.set(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c);
                    this.aabbMax.set(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f);
                    boolean visible = this.culling.isAABBVisible(this.aabbMin, this.aabbMax, camera);
                    cullable.setCulled(!visible);
                }
                this.lastTime = System.currentTimeMillis() - start;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("Shutting down culling task!");
    }

    private boolean isSkippableArmorstand(Entity entity) {
        if (!EntityCullingModBase.instance.config.skipMarkerArmorStands) {
            return false;
        }
        return entity instanceof ArmorStandEntity && ((ArmorStandEntity)entity).func_181026_s();
    }
}

