/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.items;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.config.ConfigHandler;
import com.chaosthedude.explorerscompass.gui.GuiWrapper;
import com.chaosthedude.explorerscompass.network.SyncPacket;
import com.chaosthedude.explorerscompass.util.CompassState;
import com.chaosthedude.explorerscompass.util.ItemUtils;
import com.chaosthedude.explorerscompass.util.PlayerUtils;
import com.chaosthedude.explorerscompass.util.StructureUtils;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;

public class ExplorersCompassItem
extends Item {
    public static final String NAME = "explorerscompass";

    public ExplorersCompassItem() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78040_i));
        this.setRegistryName(NAME);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (!player.func_213453_ef()) {
            if (world.field_72995_K) {
                ItemStack stack = ItemUtils.getHeldItem(player, ExplorersCompass.explorersCompass);
                GuiWrapper.openGUI(world, player, stack);
            } else {
                ServerWorld serverWorld = (ServerWorld)world;
                ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
                boolean canTeleport = (Boolean)ConfigHandler.GENERAL.allowTeleport.get() != false && PlayerUtils.canTeleport(player);
                List<Structure<?>> allowedStructures = StructureUtils.getAllowedStructures();
                Map<Structure<?>, List<ResourceLocation>> dimensionsForAllowedStructures = StructureUtils.getDimensionsForAllowedStructures(serverWorld);
                ExplorersCompass.network.sendTo((Object)new SyncPacket(canTeleport, allowedStructures, dimensionsForAllowedStructures), serverPlayer.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
            }
        } else {
            this.setState(player.func_184586_b(hand), null, CompassState.INACTIVE, player);
        }
        return new ActionResult(ActionResultType.PASS, (Object)player.func_184586_b(hand));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (this.getState(oldStack) == this.getState(newStack)) {
            return false;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public void searchForStructure(World world, PlayerEntity player, ResourceLocation structureKey, BlockPos pos, ItemStack stack) {
        this.setSearching(stack, structureKey, player);
        this.setSearchRadius(stack, 0, player);
        if (world instanceof ServerWorld) {
            StructureUtils.searchForStructure((ServerWorld)world, player, stack, StructureUtils.getStructureForKey(structureKey), pos);
        }
    }

    public boolean isActive(ItemStack stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return this.getState(stack) != CompassState.INACTIVE;
        }
        return false;
    }

    public void setSearching(ItemStack stack, ResourceLocation structureKey, PlayerEntity player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.func_77978_p().func_74778_a("StructureKey", structureKey.toString());
            stack.func_77978_p().func_74768_a("State", CompassState.SEARCHING.getID());
        }
    }

    public void setFound(ItemStack stack, int x, int z, int samples, PlayerEntity player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.func_77978_p().func_74768_a("State", CompassState.FOUND.getID());
            stack.func_77978_p().func_74768_a("FoundX", x);
            stack.func_77978_p().func_74768_a("FoundZ", z);
            stack.func_77978_p().func_74768_a("Samples", samples);
        }
    }

    public void setNotFound(ItemStack stack, PlayerEntity player, int searchRadius, int samples) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.func_77978_p().func_74768_a("State", CompassState.NOT_FOUND.getID());
            stack.func_77978_p().func_74768_a("SearchRadius", searchRadius);
            stack.func_77978_p().func_74768_a("Samples", samples);
        }
    }

    public void setInactive(ItemStack stack, PlayerEntity player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.func_77978_p().func_74768_a("State", CompassState.INACTIVE.getID());
        }
    }

    public void setState(ItemStack stack, BlockPos pos, CompassState state, PlayerEntity player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.func_77978_p().func_74768_a("State", state.getID());
        }
    }

    public void setFoundStructureX(ItemStack stack, int x, PlayerEntity player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.func_77978_p().func_74768_a("FoundX", x);
        }
    }

    public void setFoundStructureZ(ItemStack stack, int z, PlayerEntity player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.func_77978_p().func_74768_a("FoundZ", z);
        }
    }

    public void setStructureKey(ItemStack stack, ResourceLocation structureKey, PlayerEntity player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.func_77978_p().func_74778_a("StructureKey", structureKey.toString());
        }
    }

    public void setSearchRadius(ItemStack stack, int searchRadius, PlayerEntity player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.func_77978_p().func_74768_a("SearchRadius", searchRadius);
        }
    }

    public void setSamples(ItemStack stack, int samples, PlayerEntity player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.func_77978_p().func_74768_a("Samples", samples);
        }
    }

    public void setDisplayCoordinates(ItemStack stack, boolean displayPosition) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.func_77978_p().func_74757_a("DisplayCoordinates", displayPosition);
        }
    }

    public CompassState getState(ItemStack stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return CompassState.fromID(stack.func_77978_p().func_74762_e("State"));
        }
        return null;
    }

    public int getFoundStructureX(ItemStack stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return stack.func_77978_p().func_74762_e("FoundX");
        }
        return 0;
    }

    public int getFoundStructureZ(ItemStack stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return stack.func_77978_p().func_74762_e("FoundZ");
        }
        return 0;
    }

    public ResourceLocation getStructureKey(ItemStack stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return new ResourceLocation(stack.func_77978_p().func_74779_i("StructureKey"));
        }
        return new ResourceLocation("");
    }

    public int getSearchRadius(ItemStack stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return stack.func_77978_p().func_74762_e("SearchRadius");
        }
        return -1;
    }

    public int getSamples(ItemStack stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return stack.func_77978_p().func_74762_e("Samples");
        }
        return -1;
    }

    public int getDistanceToBiome(PlayerEntity player, ItemStack stack) {
        return StructureUtils.getDistanceToStructure(player, this.getFoundStructureX(stack), this.getFoundStructureZ(stack));
    }

    public boolean shouldDisplayCoordinates(ItemStack stack) {
        if (ItemUtils.verifyNBT(stack) && stack.func_77978_p().func_74764_b("DisplayCoordinates")) {
            return stack.func_77978_p().func_74767_n("DisplayCoordinates");
        }
        return true;
    }
}

