/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.tile;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import vectorwing.farmersdelight.blocks.CuttingBoardBlock;
import vectorwing.farmersdelight.crafting.CuttingBoardRecipe;
import vectorwing.farmersdelight.mixin.accessors.RecipeManagerAccessor;
import vectorwing.farmersdelight.registry.ModAdvancements;
import vectorwing.farmersdelight.registry.ModSounds;
import vectorwing.farmersdelight.registry.ModTileEntityTypes;
import vectorwing.farmersdelight.tile.FDSyncedTileEntity;
import vectorwing.farmersdelight.utils.ItemUtils;
import vectorwing.farmersdelight.utils.TextUtils;
import vectorwing.farmersdelight.utils.tags.ForgeTags;

public class CuttingBoardTileEntity
extends FDSyncedTileEntity {
    private final ItemStackHandler inventory = this.createHandler();
    private final LazyOptional<IItemHandler> inputHandler = LazyOptional.of(() -> this.inventory);
    private ResourceLocation lastRecipeID;
    private boolean isItemCarvingBoard = false;

    public CuttingBoardTileEntity() {
        super((TileEntityType)ModTileEntityTypes.CUTTING_BOARD_TILE.get());
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.isItemCarvingBoard = compound.func_74767_n("IsItemCarved");
        this.inventory.deserializeNBT(compound.func_74775_l("Inventory"));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("Inventory", (INBT)this.inventory.serializeNBT());
        compound.func_74757_a("IsItemCarved", this.isItemCarvingBoard);
        return compound;
    }

    public boolean processStoredItemUsingTool(ItemStack toolStack, @Nullable PlayerEntity player) {
        if (this.field_145850_b == null) {
            return false;
        }
        Optional<CuttingBoardRecipe> matchingRecipe = this.getMatchingRecipe(new RecipeWrapper((IItemHandlerModifiable)this.inventory), toolStack, player);
        matchingRecipe.ifPresent(recipe -> {
            List<ItemStack> results = recipe.rollResults(this.field_145850_b.field_73012_v, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)toolStack));
            for (ItemStack resultStack : results) {
                Direction direction = ((Direction)this.func_195044_w().func_177229_b((Property)CuttingBoardBlock.field_185512_D)).func_176735_f();
                ItemUtils.spawnItemEntity(this.field_145850_b, resultStack.func_77946_l(), (double)this.field_174879_c.func_177958_n() + 0.5 + (double)direction.func_82601_c() * 0.2, (double)this.field_174879_c.func_177956_o() + 0.2, (double)this.field_174879_c.func_177952_p() + 0.5 + (double)direction.func_82599_e() * 0.2, (float)direction.func_82601_c() * 0.2f, 0.0, (float)direction.func_82599_e() * 0.2f);
            }
            if (player != null) {
                toolStack.func_222118_a(1, (LivingEntity)player, user -> user.func_213361_c(EquipmentSlotType.MAINHAND));
            } else if (toolStack.func_96631_a(1, this.field_145850_b.field_73012_v, null)) {
                toolStack.func_190920_e(0);
            }
            this.playProcessingSound(recipe.getSoundEventID(), toolStack.func_77973_b(), this.getStoredItem().func_77973_b());
            this.removeItem();
            if (player instanceof ServerPlayerEntity) {
                ModAdvancements.CUTTING_BOARD.trigger((ServerPlayerEntity)player);
            }
        });
        return matchingRecipe.isPresent();
    }

    private Optional<CuttingBoardRecipe> getMatchingRecipe(RecipeWrapper recipeWrapper, ItemStack toolStack, @Nullable PlayerEntity player) {
        IRecipe recipe;
        if (this.field_145850_b == null) {
            return Optional.empty();
        }
        if (this.lastRecipeID != null && (recipe = ((RecipeManagerAccessor)this.field_145850_b.func_199532_z()).getRecipeMap(CuttingBoardRecipe.TYPE).get(this.lastRecipeID)) instanceof CuttingBoardRecipe && recipe.func_77569_a((IInventory)recipeWrapper, this.field_145850_b) && ((CuttingBoardRecipe)recipe).getTool().test(toolStack)) {
            return Optional.of((CuttingBoardRecipe)recipe);
        }
        List recipeList = this.field_145850_b.func_199532_z().func_215370_b(CuttingBoardRecipe.TYPE, (IInventory)recipeWrapper, this.field_145850_b);
        if (recipeList.isEmpty()) {
            if (player != null) {
                player.func_146105_b((ITextComponent)TextUtils.getTranslation("block.cutting_board.invalid_item", new Object[0]), true);
            }
            return Optional.empty();
        }
        Optional<CuttingBoardRecipe> recipe2 = recipeList.stream().filter(cuttingRecipe -> cuttingRecipe.getTool().test(toolStack)).findFirst();
        if (!recipe2.isPresent()) {
            if (player != null) {
                player.func_146105_b((ITextComponent)TextUtils.getTranslation("block.cutting_board.invalid_tool", new Object[0]), true);
            }
            return Optional.empty();
        }
        this.lastRecipeID = recipe2.get().func_199560_c();
        return recipe2;
    }

    public void playProcessingSound(String soundEventID, Item tool, Item boardItem) {
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(soundEventID));
        if (sound != null) {
            this.playSound(sound, 1.0f, 1.0f);
        } else if (tool.func_206844_a((ITag)Tags.Items.SHEARS)) {
            this.playSound(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
        } else if (tool.func_206844_a(ForgeTags.TOOLS_KNIVES)) {
            this.playSound((SoundEvent)ModSounds.BLOCK_CUTTING_BOARD_KNIFE.get(), 0.8f, 1.0f);
        } else if (boardItem instanceof BlockItem) {
            Block block = ((BlockItem)boardItem).func_179223_d();
            SoundType soundType = block.func_176223_P().func_215695_r();
            this.playSound(soundType.func_185845_c(), 1.0f, 0.8f);
        } else {
            this.playSound(SoundEvents.field_187881_gQ, 1.0f, 0.8f);
        }
    }

    public void playSound(SoundEvent sound, float volume, float pitch) {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184148_a(null, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), sound, SoundCategory.BLOCKS, volume, pitch);
        }
    }

    public boolean addItem(ItemStack itemStack) {
        if (this.isEmpty() && !itemStack.func_190926_b()) {
            this.inventory.setStackInSlot(0, itemStack.func_77979_a(1));
            this.isItemCarvingBoard = false;
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public boolean carveToolOnBoard(ItemStack tool) {
        if (this.addItem(tool)) {
            this.isItemCarvingBoard = true;
            return true;
        }
        return false;
    }

    public ItemStack removeItem() {
        if (!this.isEmpty()) {
            this.isItemCarvingBoard = false;
            ItemStack item = this.getStoredItem().func_77979_a(1);
            this.inventoryChanged();
            return item;
        }
        return ItemStack.field_190927_a;
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public ItemStack getStoredItem() {
        return this.inventory.getStackInSlot(0);
    }

    public boolean isEmpty() {
        return this.inventory.getStackInSlot(0).func_190926_b();
    }

    public boolean isItemCarvingBoard() {
        return this.isItemCarvingBoard;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
            return this.inputHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.inputHandler.invalidate();
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(){

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                CuttingBoardTileEntity.this.inventoryChanged();
            }
        };
    }
}

