/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.util.matrix;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import me.paulf.fairylights.util.matrix.Matrix;
import me.paulf.fairylights.util.matrix.Matrix4;
import net.minecraft.util.math.vector.Vector3d;

public final class MatrixStack
implements Matrix {
    private final Deque<Matrix4> stack = new ArrayDeque<Matrix4>();

    public MatrixStack() {
        Matrix4 mat = new Matrix4();
        mat.asIdentity();
        this.stack.addLast(mat);
    }

    public void push() {
        this.stack.addLast(new Matrix4(this.stack.getLast()));
    }

    public void pop() {
        if (this.stack.size() <= 1) {
            throw new IllegalStateException("stack underflow");
        }
        this.stack.removeLast();
    }

    @Override
    public void translate(float x, float y, float z) {
        Matrix4 mat = this.stack.getLast();
        Matrix4 translation = new Matrix4();
        translation.asTranslation(x, y, z);
        mat.mul(translation);
    }

    @Override
    public void rotate(float angle, float x, float y, float z) {
        Matrix4 mat = this.stack.getLast();
        Matrix4 rotation = new Matrix4();
        rotation.asRotation(x, y, z, angle);
        mat.mul(rotation);
    }

    public void scale(float x, float y, float z) {
        Matrix4 mat = this.stack.getLast();
        Matrix4 scale = new Matrix4();
        scale.m00 = x;
        scale.m11 = y;
        scale.m22 = z;
        scale.m33 = 1.0f;
        mat.mul(scale);
    }

    public Vector3d transform(Vector3d point) {
        Objects.requireNonNull(point, "point");
        Matrix4 mat = this.stack.getLast();
        return mat.transform(point);
    }
}

