/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import me.paulf.fairylights.FairyLights;
import me.paulf.fairylights.client.gui.component.ColorButton;
import me.paulf.fairylights.client.gui.component.PaletteButton;
import me.paulf.fairylights.client.gui.component.StyledTextFieldWidget;
import me.paulf.fairylights.client.gui.component.ToggleButton;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.connection.Lettered;
import me.paulf.fairylights.server.net.serverbound.EditLetteredConnectionMessage;
import me.paulf.fairylights.util.styledstring.StyledString;
import me.paulf.fairylights.util.styledstring.StylingPresence;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public final class EditLetteredConnectionScreen<C extends Connection>
extends Screen {
    public static final ResourceLocation WIDGETS_TEXTURE = new ResourceLocation("fairylights", "textures/gui/widgets.png");
    private final C connection;
    private StyledTextFieldWidget textField;
    private Button doneBtn;
    private Button cancelBtn;
    private ColorButton colorBtn;
    private ToggleButton boldBtn;
    private ToggleButton italicBtn;
    private ToggleButton underlineBtn;
    private ToggleButton strikethroughBtn;
    private PaletteButton paletteBtn;

    public EditLetteredConnectionScreen(C connection) {
        super(NarratorChatListener.field_216868_a);
        this.connection = connection;
    }

    public void func_231160_c_() {
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        int pad = 4;
        int buttonWidth = 150;
        this.doneBtn = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 4 - 150, this.field_230709_l_ / 4 + 120 + 12, 150, 20, (ITextComponent)new TranslationTextComponent("gui.done"), b -> {
            FairyLights.NETWORK.sendToServer(new EditLetteredConnectionMessage<C>(this.connection, this.textField.getValue()));
            this.func_231175_as__();
        }));
        this.cancelBtn = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 4, this.field_230709_l_ / 4 + 120 + 12, 150, 20, (ITextComponent)new TranslationTextComponent("gui.cancel"), b -> this.func_231175_as__()));
        int textFieldX = this.field_230708_k_ / 2 - 150;
        int textFieldY = this.field_230709_l_ / 2 - 10;
        int buttonX = textFieldX;
        int buttonY = textFieldY - 25;
        int bInc = 24;
        this.colorBtn = (ColorButton)this.func_230480_a_((Widget)new ColorButton(buttonX, buttonY, StringTextComponent.field_240750_d_, b -> {
            this.paletteBtn.field_230694_p_ = !this.paletteBtn.field_230694_p_;
        }));
        this.paletteBtn = (PaletteButton)this.func_230480_a_((Widget)new PaletteButton(buttonX - 4, buttonY - 30, this.colorBtn, (ITextComponent)new TranslationTextComponent("fairylights.color"), b -> this.textField.updateStyling(this.colorBtn.getDisplayColor(), true)));
        this.boldBtn = (ToggleButton)this.func_230480_a_((Widget)new ToggleButton(buttonX += 24, buttonY, 40, 0, StringTextComponent.field_240750_d_, b -> this.updateStyleButton(TextFormatting.BOLD, this.boldBtn)));
        this.italicBtn = (ToggleButton)this.func_230480_a_((Widget)new ToggleButton(buttonX += 24, buttonY, 60, 0, StringTextComponent.field_240750_d_, b -> this.updateStyleButton(TextFormatting.ITALIC, this.italicBtn)));
        this.underlineBtn = (ToggleButton)this.func_230480_a_((Widget)new ToggleButton(buttonX += 24, buttonY, 80, 0, StringTextComponent.field_240750_d_, b -> this.updateStyleButton(TextFormatting.UNDERLINE, this.underlineBtn)));
        this.strikethroughBtn = (ToggleButton)this.func_230480_a_((Widget)new ToggleButton(buttonX += 24, buttonY, 100, 0, StringTextComponent.field_240750_d_, b -> this.updateStyleButton(TextFormatting.STRIKETHROUGH, this.strikethroughBtn)));
        this.textField = new StyledTextFieldWidget(this.field_230712_o_, this.colorBtn, this.boldBtn, this.italicBtn, this.underlineBtn, this.strikethroughBtn, textFieldX, textFieldY, 300, 20, (ITextComponent)new TranslationTextComponent("fairylights.letteredText"));
        this.textField.setValue(((Lettered)this.connection).getText());
        this.textField.setCaretStart();
        this.textField.setIsBlurable(false);
        this.textField.registerChangeListener(this::validateText);
        this.textField.setCharInputTransformer(((Lettered)this.connection).getInputTransformer());
        this.textField.func_230996_d_(true);
        this.field_230705_e_.add(this.textField);
        this.paletteBtn.field_230694_p_ = false;
        StylingPresence ss = ((Lettered)this.connection).getSupportedStyling();
        this.colorBtn.field_230694_p_ = ss.hasColor();
        this.boldBtn.field_230694_p_ = ss.hasBold();
        this.italicBtn.field_230694_p_ = ss.hasItalic();
        this.underlineBtn.field_230694_p_ = ss.hasUnderline();
        this.strikethroughBtn.field_230694_p_ = ss.hasStrikethrough();
        this.func_212928_a(this.textField);
    }

    private void validateText(StyledString text) {
        this.doneBtn.field_230693_o_ = ((Lettered)this.connection).isSupportedText(text) && !((Lettered)this.connection).getText().equals(text);
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    public void func_231023_e_() {
        Minecraft mc = Minecraft.func_71410_x();
        int x = (int)(mc.field_71417_B.func_198024_e() * (double)mc.func_228018_at_().func_198107_o() / (double)mc.func_228018_at_().func_198105_m());
        int y = (int)(mc.field_71417_B.func_198026_f() * (double)mc.func_228018_at_().func_198087_p() / (double)mc.func_228018_at_().func_198083_n());
        this.textField.update(x, y);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        this.paletteBtn.field_230694_p_ = false;
        if (EditLetteredConnectionScreen.isControlOp(keyCode, 66)) {
            this.toggleStyleButton(TextFormatting.BOLD, this.boldBtn);
            return true;
        }
        if (EditLetteredConnectionScreen.isControlOp(keyCode, 73)) {
            this.toggleStyleButton(TextFormatting.ITALIC, this.italicBtn);
            return true;
        }
        if (EditLetteredConnectionScreen.isControlOp(keyCode, 85)) {
            this.toggleStyleButton(TextFormatting.UNDERLINE, this.underlineBtn);
            return true;
        }
        if (EditLetteredConnectionScreen.isControlOp(keyCode, 83)) {
            this.toggleStyleButton(TextFormatting.STRIKETHROUGH, this.strikethroughBtn);
            return true;
        }
        if (super.func_231046_a_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if ((keyCode == 257 || keyCode == 335) && this.doneBtn.field_230693_o_) {
            this.doneBtn.func_230930_b_();
            return true;
        }
        if (keyCode == 256) {
            this.cancelBtn.func_230930_b_();
            return true;
        }
        return false;
    }

    private void toggleStyleButton(TextFormatting styling, ToggleButton btn) {
        btn.setValue(!btn.getValue());
        this.updateStyleButton(styling, btn);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (super.func_231044_a_(mouseX, mouseY, button)) {
            return true;
        }
        this.paletteBtn.field_230694_p_ = false;
        return false;
    }

    private void updateStyleButton(TextFormatting styling, ToggleButton btn) {
        if (btn.field_230694_p_) {
            this.textField.updateStyling(styling, btn.getValue());
        }
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float delta) {
        this.func_230446_a_(stack);
        EditLetteredConnectionScreen.func_238472_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("fairylights.editLetteredConnection"), (int)(this.field_230708_k_ / 2), (int)20, (int)0xFFFFFF);
        super.func_230430_a_(stack, mouseX, mouseY, delta);
        this.textField.func_230430_a_(stack, mouseX, mouseY, delta);
        String allowed = ((Lettered)this.connection).getAllowedDescription();
        if (!allowed.isEmpty()) {
            EditLetteredConnectionScreen.func_238475_b_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("fairylights.editLetteredConnection.allowed_characters", new Object[]{allowed}).func_240699_a_(TextFormatting.GRAY), (int)this.textField.field_230690_l_, (int)(this.textField.field_230691_m_ + 24), (int)-1);
        }
    }

    public static boolean isControlOp(int key, int controlKey) {
        return key == controlKey && Screen.func_231172_r_() && !Screen.func_231173_s_() && !Screen.func_231174_t_();
    }
}

