/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.valhelsia.valhelsia_core.client.Cosmetic;
import net.valhelsia.valhelsia_core.client.CosmeticsCategory;
import net.valhelsia.valhelsia_core.client.CosmeticsManager;
import net.valhelsia.valhelsia_core.client.CosmeticsModels;
import net.valhelsia.valhelsia_core.client.model.CosmeticsModel;
import net.valhelsia.valhelsia_core.client.model.WitchHatModel;

public class CosmeticsHatLayer<T extends AbstractClientPlayerEntity>
extends LayerRenderer<T, PlayerModel<T>> {
    private final CosmeticsManager cosmeticsManager;
    private CosmeticsModel<T> model = new WitchHatModel();

    public CosmeticsHatLayer(LivingRenderer<T, PlayerModel<T>> entityRenderer) {
        super(entityRenderer);
        this.cosmeticsManager = CosmeticsManager.getInstance();
    }

    public void render(@Nonnull MatrixStack poseStack, @Nonnull IRenderTypeBuffer buffer, int packedLight, @Nonnull T player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        UUID uuid = player.func_110124_au();
        List<Cosmetic> cosmetics = this.cosmeticsManager.getCosmeticsForPlayer(uuid, CosmeticsCategory.HAT);
        Cosmetic activeCosmetic = this.cosmeticsManager.getActiveCosmeticForPlayer(uuid, CosmeticsCategory.HAT);
        if (activeCosmetic == null || !cosmetics.contains(activeCosmetic)) {
            return;
        }
        ResourceLocation texture = this.cosmeticsManager.getCosmeticTexture(activeCosmetic);
        if (texture == null) {
            return;
        }
        this.model = CosmeticsModels.getFromCosmetic(activeCosmetic);
        poseStack.func_227860_a_();
        if (this.model.translateToParent()) {
            ((PlayerModel)this.func_215332_c()).field_78116_c.func_228307_a_(poseStack);
        }
        if (this.model != null) {
            IVertexBuilder vertexConsumer = buffer.getBuffer(RenderType.func_228638_b_((ResourceLocation)texture));
            this.model.setPosition(poseStack);
            this.model.getModel().func_225598_a_(poseStack, vertexConsumer, packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        poseStack.func_227865_b_();
    }
}

