/*
 * Decompiled with CFR 0.152.
 */
package com.github.alienpatois.turtlemancy.world;

import com.github.alienpatois.turtlemancy.common.entities.MagmaTurtleEntity;
import com.github.alienpatois.turtlemancy.common.items.MagmaticTurtleArmorItem;
import com.github.alienpatois.turtlemancy.common.items.TurtleArmorItem;
import com.github.alienpatois.turtlemancy.core.init.ItemInit;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class TurtlemancerInteractions {
    @SubscribeEvent
    public static void fillEssence(PlayerInteractEvent.EntityInteract event) {
        World world = event.getWorld();
        if (world.field_72995_K || event.getPlayer().func_184614_ca().func_77973_b() != Items.field_151069_bo || event.getHand().equals((Object)Hand.OFF_HAND)) {
            return;
        }
        if (!(event.getTarget() instanceof LivingEntity)) {
            return;
        }
        ServerPlayerEntity p = (ServerPlayerEntity)event.getPlayer();
        if (!p.func_192039_O().func_192747_a(world.func_73046_m().func_191949_aK().func_192778_a(new ResourceLocation("turtlemancy:turtlemancer"))).func_192105_a()) {
            return;
        }
        LivingEntity e = (LivingEntity)event.getTarget();
        if (e instanceof TurtleEntity || e instanceof MagmaTurtleEntity) {
            p.func_191521_c(new ItemStack((IItemProvider)ItemInit.TURTLE_ESSENCE.get()));
        } else if (e instanceof EndermanEntity) {
            ((EndermanEntity)e).func_70624_b((LivingEntity)p);
            p.func_191521_c(new ItemStack((IItemProvider)ItemInit.ENDERMAN_ESSENCE.get()));
        } else if (e.func_70668_bt().equals(CreatureAttribute.field_223223_b_)) {
            p.func_191521_c(new ItemStack((IItemProvider)ItemInit.UNDEAD_ESSENCE.get()));
        } else if (e.func_70668_bt().equals(CreatureAttribute.field_223224_c_)) {
            p.func_191521_c(new ItemStack((IItemProvider)ItemInit.ARTHROPOD_ESSENCE.get()));
        } else if (e.func_70668_bt().equals(CreatureAttribute.field_203100_e)) {
            p.func_191521_c(new ItemStack((IItemProvider)ItemInit.WATER_CREATURE_ESSENCE.get()));
        } else if (e.func_70668_bt().equals(CreatureAttribute.field_223225_d_) || e instanceof AbstractVillagerEntity || e instanceof PlayerEntity) {
            p.func_191521_c(new ItemStack((IItemProvider)ItemInit.HUMAN_ESSENCE.get()));
        } else if (e instanceof AnimalEntity) {
            p.func_191521_c(new ItemStack((IItemProvider)ItemInit.ANIMAL_ESSENCE.get()));
        } else {
            return;
        }
        p.func_184614_ca().func_190918_g(1);
    }

    @SubscribeEvent
    public static void onTurtleArmorEquip(LivingEquipmentChangeEvent event) {
        EquipmentSlotType slotChanged;
        if (event.getEntityLiving() instanceof PlayerEntity && (slotChanged = event.getSlot()).func_188452_c() > 0 && slotChanged.func_188452_c() < 5) {
            ItemStack previousArmorPiece = event.getFrom();
            ItemStack newArmorPiece = event.getTo();
            if (previousArmorPiece.func_77973_b() instanceof TurtleArmorItem || newArmorPiece.func_77973_b() instanceof TurtleArmorItem) {
                ModifiableAttributeInstance health;
                if (previousArmorPiece.func_77973_b() instanceof TurtleArmorItem && (health = event.getEntityLiving().func_110148_a(Attributes.field_233818_a_)) != null && health.func_180374_a(TurtleArmorItem.MORE_HEALTH)) {
                    health.func_111124_b(TurtleArmorItem.MORE_HEALTH);
                }
                if (newArmorPiece.func_77973_b() instanceof TurtleArmorItem) {
                    ModifiableAttributeInstance health2;
                    PlayerEntity p = (PlayerEntity)event.getEntityLiving();
                    int fullEquip = 0;
                    for (ItemStack armor : p.func_184193_aE()) {
                        if (!(armor.func_77973_b() instanceof TurtleArmorItem)) continue;
                        ++fullEquip;
                    }
                    if (fullEquip == 4 && (health2 = event.getEntityLiving().func_110148_a(Attributes.field_233818_a_)) != null && !health2.func_180374_a(TurtleArmorItem.MORE_HEALTH)) {
                        health2.func_233769_c_(TurtleArmorItem.MORE_HEALTH);
                    }
                }
            } else if (previousArmorPiece.func_77973_b() instanceof MagmaticTurtleArmorItem || newArmorPiece.func_77973_b() instanceof MagmaticTurtleArmorItem) {
                ModifiableAttributeInstance health;
                if (previousArmorPiece.func_77973_b() instanceof MagmaticTurtleArmorItem && (health = event.getEntityLiving().func_110148_a(Attributes.field_233818_a_)) != null && health.func_180374_a(MagmaticTurtleArmorItem.LESS_HEALTH)) {
                    health.func_111124_b(MagmaticTurtleArmorItem.LESS_HEALTH);
                }
                if (newArmorPiece.func_77973_b() instanceof MagmaticTurtleArmorItem) {
                    PlayerEntity p = (PlayerEntity)event.getEntityLiving();
                    int fullEquip = 0;
                    ModifiableAttributeInstance health2 = p.func_184193_aE().iterator();
                    while (health2.hasNext()) {
                        ItemStack armor = (ItemStack)health2.next();
                        if (!(armor.func_77973_b() instanceof MagmaticTurtleArmorItem)) continue;
                        ++fullEquip;
                    }
                    if (fullEquip == 4 && (health2 = event.getEntityLiving().func_110148_a(Attributes.field_233818_a_)) != null && !health2.func_180374_a(MagmaticTurtleArmorItem.LESS_HEALTH)) {
                        health2.func_233769_c_(MagmaticTurtleArmorItem.LESS_HEALTH);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void fallDamage(LivingFallEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity && event.isCancelable() && CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemInit.NAUTILUS_BELT.get(), (LivingEntity)((PlayerEntity)event.getEntityLiving())).isPresent()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingAttackEvent(LivingAttackEvent event) {
        World entityWorld = event.getEntity().func_130014_f_();
        if (entityWorld.field_72995_K) {
            return;
        }
        if (event.getEntityLiving() instanceof PlayerEntity && event.getEntityLiving().func_110148_a(Attributes.field_233818_a_).func_180374_a(MagmaticTurtleArmorItem.LESS_HEALTH) && event.getSource().func_76364_f() != null) {
            event.getSource().func_76346_g().func_70015_d(1);
        }
    }

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        World entityWorld = event.getEntity().func_130014_f_();
        if (entityWorld.field_72995_K) {
            return;
        }
        if (event.getSource().func_76346_g() instanceof PlayerEntity) {
            PlayerEntity killer = (PlayerEntity)event.getSource().func_76346_g();
            if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemInit.MAGMA_HEART.get(), (LivingEntity)killer).isPresent()) {
                killer.func_70691_i(4.0f);
                killer.func_71024_bL().func_75122_a(4, 0.0f);
            }
        }
    }

    @SubscribeEvent
    public static void leftClick(PlayerInteractEvent.LeftClickBlock event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        BlockState blockstate = world.func_180495_p(event.getPos());
        Block block = blockstate.func_177230_c();
        PlayerEntity player = event.getPlayer();
        if (block == Blocks.field_150357_h && player.func_184614_ca().func_77973_b() == ItemInit.BEDROCK_PICKAXE.get()) {
            boolean removed;
            event.getUseItem();
            event.setUseItem(Event.Result.ALLOW);
            event.getUseBlock();
            event.setUseBlock(Event.Result.ALLOW);
            ItemStack itemstack = player.func_184614_ca();
            ItemStack itemstack1 = itemstack.func_77946_l();
            BlockPos pos = event.getPos();
            itemstack.func_179548_a(world, blockstate, pos, player);
            if (itemstack.func_190926_b() && !itemstack1.func_190926_b()) {
                ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)player, (ItemStack)itemstack1, (Hand)Hand.MAIN_HAND);
            }
            if (removed = blockstate.removedByPlayer(world, pos, player, true, world.func_204610_c(pos))) {
                blockstate.func_177230_c().func_176206_d((IWorld)world, pos, blockstate);
                block.func_180657_a(world, player, pos, blockstate, null, itemstack1);
                blockstate.func_177230_c().func_180637_b((ServerWorld)world, pos, 10);
                player.func_191521_c(new ItemStack((IItemProvider)Items.field_221598_z));
                itemstack.func_222118_a(itemstack.func_77958_k() / 4, (LivingEntity)player, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
            }
        }
    }
}

