/*
 * Decompiled with CFR 0.152.
 */
package com.github.alienpatois.turtlemancy.world;

import com.github.alienpatois.turtlemancy.config.CommonConfig;
import com.github.alienpatois.turtlemancy.core.init.BlockInit;
import com.github.alienpatois.turtlemancy.core.init.EntityTypeInit;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.tags.ITag;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.TagMatchRuleTest;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class TurtleStuffGeneration {
    public static void generateStuff(BiomeLoadingEvent event) {
        if (event.getCategory().equals((Object)Biome.Category.BEACH)) {
            TurtleStuffGeneration.generate(event.getGeneration(), (RuleTest)new TagMatchRuleTest((ITag)Tags.Blocks.SAND), ((Block)BlockInit.OYSTER_SAND.get()).func_176223_P(), 3, 43, 83, (Integer)CommonConfig.oyster_sand_chance.get());
        }
        int weight = (Integer)CommonConfig.magma_turtle_weight.get();
        if (event.getCategory().equals((Object)Biome.Category.NETHER) && weight > 0) {
            List spawns = event.getSpawns().getSpawner(EntityClassification.MONSTER);
            spawns.add(new MobSpawnInfo.Spawners((EntityType)EntityTypeInit.MAGMA_TURTLE.get(), weight, 1, 3));
        }
    }

    public static void generate(BiomeGenerationSettingsBuilder settings, RuleTest fillerType, BlockState state, int veinSize, int minHeight, int maxHeight, int amountPerChunk) {
        settings.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(fillerType, state, veinSize)).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(minHeight, 0, maxHeight))).func_242728_a()).func_242731_b(amountPerChunk));
    }
}

