/*
 * Decompiled with CFR 0.152.
 */
package com.github.alienpatois.turtlemancy.networking;

import com.github.alienpatois.turtlemancy.Turtlemancy;
import com.github.alienpatois.turtlemancy.common.entities.MagmaTurtleEntity;
import com.github.alienpatois.turtlemancy.common.items.TurtlemancerWand;
import com.github.alienpatois.turtlemancy.core.init.ItemInit;
import com.github.alienpatois.turtlemancy.networking.TurtleBenditionMessageToServer;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageHandlerOnServer {
    static Random rand = new Random();

    public static void onMessageReceived(TurtleBenditionMessageToServer message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived != LogicalSide.SERVER) {
            Turtlemancy.LOGGER.warn("TurtleBenditionMessageToServer received on wrong side:" + ctx.getDirection().getReceptionSide());
            return;
        }
        if (!message.isMessageValid()) {
            Turtlemancy.LOGGER.warn("TurtleBenditionMessageToServer was invalid" + message.toString());
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            Turtlemancy.LOGGER.warn("EntityPlayerMP was null when TurtleBenditionMessageToServer was received");
        }
        ctx.enqueueWork(() -> MessageHandlerOnServer.processMessage(message, sendingPlayer));
    }

    static void processMessage(TurtleBenditionMessageToServer message, ServerPlayerEntity sendingPlayer) {
        ServerWorld world = sendingPlayer.func_71121_q();
        Entity turtle = world.func_73045_a(message.getTurtleID());
        if (turtle instanceof PlayerEntity) {
            Item wand = ((PlayerEntity)turtle).func_184582_a(EquipmentSlotType.MAINHAND).func_77973_b();
            if (wand instanceof TurtlemancerWand) {
                ((TurtlemancerWand)wand).selfBubble((PlayerEntity)sendingPlayer);
            }
        } else if (turtle instanceof TurtleEntity || turtle instanceof MagmaTurtleEntity) {
            BasicParticleType particleType = ParticleTypes.field_197633_z;
            if (turtle instanceof TurtleEntity) {
                sendingPlayer.func_192039_O().func_192750_a(world.func_73046_m().func_191949_aK().func_192778_a(new ResourceLocation("turtlemancy:turtlemancer")), "turtle_bendition");
                if (sendingPlayer.func_192039_O().func_192747_a(world.func_73046_m().func_191949_aK().func_192778_a(new ResourceLocation("turtlemancy:dark_turtlemancer"))).func_192105_a()) {
                    particleType = ParticleTypes.field_197609_b;
                    sendingPlayer.field_71071_by.func_70441_a(new ItemStack((IItemProvider)ItemInit.TURTLE_CURSE.get()));
                    world.func_184133_a((PlayerEntity)null, turtle.func_233580_cy_(), SoundEvents.field_187913_gm, SoundCategory.BLOCKS, 1.0f, 1.0f);
                } else {
                    sendingPlayer.field_71071_by.func_70441_a(new ItemStack((IItemProvider)ItemInit.TURTLE_BLESS.get()));
                    world.func_184133_a((PlayerEntity)null, turtle.func_233580_cy_(), SoundEvents.field_190021_aL, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            } else if (turtle instanceof MagmaTurtleEntity) {
                sendingPlayer.func_192039_O().func_192750_a(world.func_73046_m().func_191949_aK().func_192778_a(new ResourceLocation("turtlemancy:turtlemancer")), "turtle_bendition");
                particleType = ParticleTypes.field_197609_b;
                sendingPlayer.field_71071_by.func_70441_a(new ItemStack((IItemProvider)ItemInit.TURTLE_CURSE.get()));
                world.func_184133_a((PlayerEntity)null, turtle.func_233580_cy_(), SoundEvents.field_190021_aL, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            double d0 = rand.nextGaussian() * 0.02;
            for (int i = 0; i < 3; ++i) {
                sendingPlayer.func_71121_q().func_195598_a((IParticleData)particleType, turtle.func_226282_d_(1.0), turtle.func_226279_cv_() + 0.5, turtle.func_226287_g_(1.0), 1, 0.0, 0.0, 0.0, d0);
            }
        }
    }

    public static boolean isThisProtocolAcceptedByServer(String protocolVersion) {
        return "1".equals(protocolVersion);
    }
}

