/*
 * Decompiled with CFR 0.152.
 */
package com.github.alienpatois.turtlemancy.datagen;

import com.github.alienpatois.turtlemancy.config.CommonConfig;
import com.github.alienpatois.turtlemancy.core.util.CoreUtil;
import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class GlobalLootModifiers {
    public static final String MODID = "turtlemancy";

    private static class SandDropModifier
    extends LootModifier {
        private final Item item;

        public SandDropModifier(ILootCondition[] conditionsIn, Item itemCheck) {
            super(conditionsIn);
            this.item = itemCheck;
        }

        @Nonnull
        public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
            int ran = CoreUtil.getRandomIntInRange(0, (Integer)CommonConfig.scute_sand_drop_chance.get() - 1);
            if (ran < 1) {
                generatedLoot.add(new ItemStack((IItemProvider)this.item, ((Integer)CommonConfig.scute_sand_drop_count.get()).intValue()));
            }
            return generatedLoot;
        }

        private static class Serializer
        extends GlobalLootModifierSerializer<SandDropModifier> {
            private Serializer() {
            }

            public SandDropModifier read(ResourceLocation name, JsonObject json, ILootCondition[] conditionsIn) {
                Item i = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"item")));
                return new SandDropModifier(conditionsIn, i);
            }

            public JsonObject write(SandDropModifier instance) {
                return null;
            }
        }
    }

    @Mod.EventBusSubscriber(modid="turtlemancy", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class EventHandlers {
        @SubscribeEvent
        public static void registerModifierSerializers(@Nonnull RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
            if (((Boolean)CommonConfig.scute_sand_drop.get()).booleanValue()) {
                event.getRegistry().register((IForgeRegistryEntry)new SandDropModifier.Serializer().setRegistryName(new ResourceLocation(GlobalLootModifiers.MODID, "sand")));
            }
        }
    }
}

