/*
 * Decompiled with CFR 0.152.
 */
package com.github.alienpatois.turtlemancy.core.util;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;

public class CoreUtil {
    public static int getRandomIntInRange(int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException("max must be greater than min (getRandomIntInRange)");
        }
        return (int)(Math.random() * (double)(max - min + 1)) + min;
    }

    public static boolean areThisVectorsInRange(Vector3d vector1, Vector3d vector2, double per) {
        double bigNumber = 0.0;
        double smallNumber = 0.0;
        boolean equal = true;
        double[] v1 = new double[]{Math.abs(vector1.func_82615_a()), Math.abs(vector1.func_82617_b()), Math.abs(vector1.func_82616_c())};
        double[] v2 = new double[]{Math.abs(vector2.func_82615_a()), Math.abs(vector2.func_82617_b()), Math.abs(vector2.func_82616_c())};
        for (int i = 0; i < v1.length; ++i) {
            if (v1[i] > v2[i]) {
                bigNumber = v1[i];
                smallNumber = v2[i];
            } else {
                bigNumber = v2[i];
                smallNumber = v1[i];
            }
            if (!(Math.abs(bigNumber - smallNumber) > bigNumber * per)) continue;
            return false;
        }
        return true;
    }

    public static RayTraceResult getMouseOver(ServerPlayerEntity entity) {
        RayTraceResult result = null;
        float partialTicks = 0.0f;
        if (entity != null && entity.func_130014_f_() != null) {
            AxisAlignedBB axisalignedbb;
            double d0 = entity.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
            result = entity.func_213324_a(d0, partialTicks, false);
            Vector3d vector3d = entity.func_174824_e(partialTicks);
            boolean flag = false;
            double d1 = d0;
            d1 *= d1;
            if (result != null) {
                d1 = result.func_216347_e().func_72436_e(vector3d);
            }
            Vector3d vector3d1 = entity.func_70676_i(1.0f);
            Vector3d vector3d2 = vector3d.func_72441_c(vector3d1.field_72450_a * d0, vector3d1.field_72448_b * d0, vector3d1.field_72449_c * d0);
            EntityRayTraceResult entityraytraceresult = CoreUtil.rayTraceEntities((Entity)entity, vector3d, vector3d2, axisalignedbb = entity.func_174813_aQ().func_216361_a(vector3d1.func_186678_a(d0)).func_72314_b(1.0, 1.0, 1.0), p_215312_0_ -> !p_215312_0_.func_175149_v() && p_215312_0_.func_70067_L(), d1);
            if (entityraytraceresult != null) {
                Vector3d vector3d3 = entityraytraceresult.func_216347_e();
                double d2 = vector3d.func_72436_e(vector3d3);
                if (flag && d2 > 9.0) {
                    result = BlockRayTraceResult.func_216352_a((Vector3d)vector3d3, (Direction)Direction.func_210769_a((double)vector3d1.field_72450_a, (double)vector3d1.field_72448_b, (double)vector3d1.field_72449_c), (BlockPos)new BlockPos(vector3d3));
                } else if (d2 < d1 || result == null) {
                    result = entityraytraceresult;
                }
            }
        }
        return result;
    }

    public static EntityRayTraceResult rayTraceEntities(Entity shooter, Vector3d startVec, Vector3d endVec, AxisAlignedBB boundingBox, Predicate<Entity> filter, double distance) {
        World world = shooter.field_70170_p;
        double d0 = distance;
        Entity entity = null;
        Vector3d vector3d = null;
        for (Entity entity1 : world.func_175674_a(shooter, boundingBox, filter)) {
            Vector3d vector3d1;
            double d1;
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)entity1.func_70111_Y());
            Optional optional = axisalignedbb.func_216365_b(startVec, endVec);
            if (axisalignedbb.func_72318_a(startVec)) {
                if (!(d0 >= 0.0)) continue;
                entity = entity1;
                vector3d = optional.orElse(startVec);
                d0 = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((d1 = startVec.func_72436_e(vector3d1 = (Vector3d)optional.get())) < d0) && d0 != 0.0) continue;
            if (entity1.func_184208_bv() == shooter.func_184208_bv() && !entity1.canRiderInteract()) {
                if (d0 != 0.0) continue;
                entity = entity1;
                vector3d = vector3d1;
                continue;
            }
            entity = entity1;
            vector3d = vector3d1;
            d0 = d1;
        }
        return entity == null ? null : new EntityRayTraceResult(entity, vector3d);
    }
}

