/*
 * Decompiled with CFR 0.152.
 */
package com.github.alienpatois.turtlemancy.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.github.alienpatois.turtlemancy.Turtlemancy;
import com.github.alienpatois.turtlemancy.config.CommonConfig;
import java.io.File;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber
public class Config {
    private static final ForgeConfigSpec.Builder server_builder = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec server_config;
    private static final ForgeConfigSpec.Builder client_builder;
    public static final ForgeConfigSpec client_config;

    public static void loadConfig(ForgeConfigSpec config, String path) {
        Turtlemancy.LOGGER.info("Loading config: " + path);
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(path)).sync().autosave().writingMode(WritingMode.REPLACE).build();
        Turtlemancy.LOGGER.info("Build config: " + path);
        file.load();
        Turtlemancy.LOGGER.info("Loaded config: " + path);
        config.setConfig((CommentedConfig)file);
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == client_config.getSpec()) {
            CommonConfig.bakeConfig();
        }
    }

    static {
        client_builder = new ForgeConfigSpec.Builder();
        CommonConfig.init(server_builder);
        CommonConfig.init(client_builder);
        server_config = server_builder.build();
        client_config = client_builder.build();
    }
}

